/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import jakarta.enterprise.inject.spi.Extension;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentCompleteServiceProcessor;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldCapability;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.MicrometerService;
import org.wildfly.extension.micrometer.MicrometerSubsystemRegistrar;
import org.wildfly.extension.micrometer.api.MicrometerCdiExtension;
import org.wildfly.extension.micrometer.metrics.MetricRegistration;
import org.wildfly.service.Installer;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

class MicrometerDeploymentProcessor
implements DeploymentUnitProcessor {
    static final String WELD_CAPABILITY_NAME = "org.wildfly.weld";
    static final AttachmentKey<MicrometerService> CONFIG_ATTACHMENT_KEY = AttachmentKey.create(MicrometerService.class);

    MicrometerDeploymentProcessor() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ServiceDependency serviceDependency = ServiceDependency.on((ServiceName)MicrometerSubsystemRegistrar.MICROMETER_SERVICE_SERVICE_NAME);
        Supplier<MetricRegistration> factory = () -> ((MicrometerService)serviceDependency.get()).collectResourceMetrics((Resource)deploymentUnit.getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE), (ImmutableManagementResourceRegistration)deploymentUnit.getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT), arg_0 -> ((PathAddress)this.createDeploymentAddressPrefix(deploymentUnit)).append(arg_0));
        ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder(factory).requires((Consumer)ServiceDependency.on((ServiceName)DeploymentCompleteServiceProcessor.serviceName((ServiceName)deploymentUnit.getServiceName())))).requires((Consumer)serviceDependency)).startWhen(Installer.StartWhen.INSTALLED)).onStop(MetricRegistration::unregister)).build()).install(phaseContext);
        this.registerCdiExtension(phaseContext, (MicrometerService)deploymentUnit.getAttachment(CONFIG_ATTACHMENT_KEY));
    }

    public void undeploy(DeploymentUnit context) {
    }

    private PathAddress createDeploymentAddressPrefix(DeploymentUnit deploymentUnit) {
        if (deploymentUnit.getParent() == null) {
            return PathAddress.pathAddress((String)"deployment", (String)((String)deploymentUnit.getAttachment(Attachments.MANAGEMENT_NAME)));
        }
        return this.createDeploymentAddressPrefix(deploymentUnit.getParent()).append("subdeployment", deploymentUnit.getName());
    }

    private void registerCdiExtension(DeploymentPhaseContext deploymentPhaseContext, MicrometerService micrometerService) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        try {
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            WeldCapability weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI(WELD_CAPABILITY_NAME, WeldCapability.class);
            if (!weldCapability.isPartOfWeldDeployment(deploymentUnit)) {
                MicrometerExtensionLogger.MICROMETER_LOGGER.noCdiDeployment();
            } else {
                weldCapability.registerExtensionInstance((Extension)new MicrometerCdiExtension((MeterRegistry)micrometerService.getMicrometerRegistry()), deploymentUnit);
            }
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            MicrometerExtensionLogger.MICROMETER_LOGGER.deploymentRequiresCapability(deploymentUnit.getName(), WELD_CAPABILITY_NAME);
        }
    }
}

