/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.config;

import jakarta.persistence.spi.PersistenceProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jipijapa.plugin.spi.PersistenceProviderAdaptor;

public class PersistenceProviderDeploymentHolder {
    private final Map<String, PersistenceProvider> providerMap = Collections.synchronizedMap(new HashMap());
    private final List<PersistenceProviderAdaptor> adapterList = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceProviderDeploymentHolder(List<PersistenceProvider> providerList, List<PersistenceProviderAdaptor> adapterList) {
        Map<String, PersistenceProvider> map = this.providerMap;
        synchronized (map) {
            for (PersistenceProvider persistenceProvider : providerList) {
                this.providerMap.put(persistenceProvider.getClass().getName(), persistenceProvider);
            }
        }
        if (adapterList != null) {
            this.adapterList.addAll(adapterList);
        }
    }

    public List<PersistenceProviderAdaptor> getAdapters() {
        return this.adapterList;
    }

    public Map<String, PersistenceProvider> getProviders() {
        return this.providerMap;
    }

    public static PersistenceProviderDeploymentHolder getPersistenceProviderDeploymentHolder(DeploymentUnit deploymentUnit) {
        deploymentUnit = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit);
        return (PersistenceProviderDeploymentHolder)deploymentUnit.getAttachment(JpaAttachments.DEPLOYED_PERSISTENCE_PROVIDER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePersistenceProviderInDeploymentUnit(DeploymentUnit deploymentUnit, List<PersistenceProvider> providerList, List<PersistenceProviderAdaptor> adaptorList) {
        PersistenceProviderDeploymentHolder persistenceProviderDeploymentHolder = PersistenceProviderDeploymentHolder.getPersistenceProviderDeploymentHolder(deploymentUnit = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit));
        if (persistenceProviderDeploymentHolder == null) {
            persistenceProviderDeploymentHolder = new PersistenceProviderDeploymentHolder(providerList, adaptorList);
            deploymentUnit.putAttachment(JpaAttachments.DEPLOYED_PERSISTENCE_PROVIDER, (Object)persistenceProviderDeploymentHolder);
        } else {
            Map<String, PersistenceProvider> map = persistenceProviderDeploymentHolder.providerMap;
            synchronized (map) {
                for (PersistenceProvider persistenceProvider : providerList) {
                    persistenceProviderDeploymentHolder.providerMap.put(persistenceProvider.getClass().getName(), persistenceProvider);
                }
            }
            if (adaptorList != null) {
                persistenceProviderDeploymentHolder.adapterList.addAll(adaptorList);
            }
        }
    }
}

