/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.beanvalidation;

import jakarta.validation.ClockProvider;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validation;
import jakarta.validation.ValidationProviderResolver;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorContext;
import jakarta.validation.ValidatorFactory;
import java.lang.reflect.InvocationTargetException;
import org.jboss.as.ee.beanvalidation.WildFlyProviderResolver;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LazyValidatorFactory
implements ValidatorFactory {
    private final ClassLoader classLoader;
    private volatile ValidatorFactory delegate;
    private volatile ConstraintValidatorFactory constraintValidatorFactory;

    public LazyValidatorFactory(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidatorFactory getDelegate() {
        ValidatorFactory result = this.delegate;
        if (result == null) {
            LazyValidatorFactory lazyValidatorFactory = this;
            synchronized (lazyValidatorFactory) {
                result = this.delegate;
                if (result == null) {
                    this.delegate = result = this.initFactory();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDelegate(ValidatorFactory validatorFactory) {
        LazyValidatorFactory lazyValidatorFactory = this;
        synchronized (lazyValidatorFactory) {
            this.delegate = validatorFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDelegate(ConstraintValidatorFactory constraintValidatorFactory) {
        LazyValidatorFactory lazyValidatorFactory = this;
        synchronized (lazyValidatorFactory) {
            this.constraintValidatorFactory = constraintValidatorFactory;
        }
    }

    public Validator getValidator() {
        return this.getDelegate().getValidator();
    }

    private ValidatorFactory initFactory() {
        ClassLoader oldTCCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            this.constraintValidatorFactory = new WildFlyDefaultConstraintValidatorFactory();
            ValidatorFactory validatorFactory = Validation.byDefaultProvider().providerResolver((ValidationProviderResolver)new WildFlyProviderResolver()).configure().constraintValidatorFactory(new ConstraintValidatorFactory(){

                public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
                    return (T)LazyValidatorFactory.this.constraintValidatorFactory.getInstance(key);
                }

                public void releaseInstance(ConstraintValidator<?, ?> instance) {
                    LazyValidatorFactory.this.constraintValidatorFactory.releaseInstance(instance);
                }
            }).buildValidatorFactory();
            return validatorFactory;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTCCL);
        }
    }

    public ValidatorContext usingContext() {
        ClassLoader oldTCCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            ValidatorContext validatorContext = this.getDelegate().usingContext();
            return validatorContext;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTCCL);
        }
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.getDelegate().getMessageInterpolator();
    }

    public TraversableResolver getTraversableResolver() {
        return this.getDelegate().getTraversableResolver();
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.getDelegate().getConstraintValidatorFactory();
    }

    public ParameterNameProvider getParameterNameProvider() {
        return this.getDelegate().getParameterNameProvider();
    }

    public ClockProvider getClockProvider() {
        return this.getDelegate().getClockProvider();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)this.getDelegate().unwrap(clazz);
    }

    public void close() {
        if (this.delegate != null) {
            this.getDelegate().close();
        }
    }

    private static class WildFlyDefaultConstraintValidatorFactory
    implements ConstraintValidatorFactory {
        private WildFlyDefaultConstraintValidatorFactory() {
        }

        public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> clazz) {
            try {
                return (T)((ConstraintValidator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public void releaseInstance(ConstraintValidator<?, ?> instance) {
        }
    }
}

