/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool.help;

import org.aesh.readline.terminal.formatting.CharacterType;
import org.aesh.readline.terminal.formatting.Color;
import org.aesh.readline.terminal.formatting.TerminalColor;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.aesh.readline.terminal.formatting.TerminalTextStyle;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.wildfly.security.tool.help.HelpCommand;

public abstract class HelpSection {
    final int leftPadding = 4;
    final int lineWidth = 120;
    final int textWidth = 116;

    public abstract void printHelp();

    protected void formatAndPrintSectionContext(CharSequence text) {
        StringBuilder stringBuilder = new StringBuilder();
        CharSequence contentText = text;
        while (0 < contentText.length()) {
            this.appendGap(stringBuilder, 4);
            if (contentText.length() <= 116) {
                stringBuilder.append(contentText);
                stringBuilder.append(System.lineSeparator());
                break;
            }
            int lineIndex = this.checkForWhitespaceIndex(contentText, 116);
            stringBuilder.append(contentText.subSequence(0, lineIndex));
            contentText = contentText.subSequence(lineIndex + 1, contentText.length());
            stringBuilder.append(System.lineSeparator());
        }
        this.printText(stringBuilder.toString());
    }

    protected void formatAndPrintTitle(String sectionTitle) {
        String titleText = new TerminalString(sectionTitle.toUpperCase(), new TerminalColor(Color.CYAN, Color.DEFAULT, Color.Intensity.BRIGHT), new TerminalTextStyle(CharacterType.BOLD)).toString();
        this.printText(titleText);
        System.out.print(System.lineSeparator());
    }

    protected int checkForWhitespaceIndex(CharSequence text, int maxWidth) {
        int lastWhitespaceIndex;
        for (lastWhitespaceIndex = maxWidth; 0 <= lastWhitespaceIndex && !Character.isWhitespace(text.charAt(lastWhitespaceIndex)); --lastWhitespaceIndex) {
        }
        return lastWhitespaceIndex;
    }

    protected void appendGap(StringBuilder text, int gapWidth) {
        for (int i = 0; i < gapWidth; ++i) {
            text.append(' ');
        }
    }

    void printText(String text) {
        TerminalConnection terminalConnection = HelpCommand.getTerminal();
        if (text != null) {
            terminalConnection.write(text);
        }
    }
}

