/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.util.Collection;
import java.util.Map;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.SyntheticPojoGenericTypeModel;

public interface HibernateOrmTypeModelFactory<T> {
    public PojoTypeModel<T> create(HibernateOrmBootstrapIntrospector var1);

    public static <T> HibernateOrmTypeModelFactory<T> entityReference(Class<T> javaClass, String entityName) {
        if (Map.class.equals(javaClass)) {
            return HibernateOrmTypeModelFactory.dynamicMap(entityName);
        }
        return HibernateOrmTypeModelFactory.rawType(javaClass);
    }

    public static <T> HibernateOrmTypeModelFactory<T> rawType(Class<T> javaClass) {
        return introspector -> introspector.typeModel(javaClass);
    }

    public static HibernateOrmTypeModelFactory<Map> dynamicMap(String name) {
        return introspector -> SyntheticPojoGenericTypeModel.opaqueType(introspector.typeModel(name));
    }

    public static <T> HibernateOrmTypeModelFactory<T[]> array(HibernateOrmTypeModelFactory<T> elementType) {
        return introspector -> SyntheticPojoGenericTypeModel.array(introspector.typeModel(Object[].class), elementType.create(introspector));
    }

    public static <C extends Collection<?>> HibernateOrmTypeModelFactory<C> collection(Class<C> collectionType, HibernateOrmTypeModelFactory<?> elementType) {
        return introspector -> SyntheticPojoGenericTypeModel.genericType(introspector.typeModel(collectionType), elementType.create(introspector), (PojoTypeModel[])new PojoTypeModel[0]);
    }

    public static <M extends Map<?, ?>> HibernateOrmTypeModelFactory<M> map(Class<M> mapType, HibernateOrmTypeModelFactory<?> keyType, HibernateOrmTypeModelFactory<?> valueType) {
        return introspector -> SyntheticPojoGenericTypeModel.genericType(introspector.typeModel(mapType), keyType.create(introspector), (PojoTypeModel[])new PojoTypeModel[]{valueType.create(introspector)});
    }
}

