/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.concurrent.CountDownLatch;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.artemis.cli.commands.ActionContext;

public class ConsumerThread
extends Thread {
    long messageCount = 1000L;
    int receiveTimeOut = 3000;
    Destination destination;
    Session session;
    ActionContext context;
    boolean durable;
    boolean breakOnNull = true;
    int sleep;
    int batchSize;
    boolean verbose;
    boolean browse;
    String filter;
    int received = 0;
    int transactions = 0;
    boolean running = false;
    CountDownLatch finished;
    boolean bytesAsText;
    MessageListener listener;

    public ConsumerThread(Session session, Destination destination, int threadNr, ActionContext context) {
        super("Consumer " + destination.toString() + ", thread=" + threadNr);
        this.destination = destination;
        this.session = session;
        this.context = context;
    }

    @Override
    public void run() {
        if (this.browse) {
            this.browse();
        } else {
            this.consume();
        }
    }

    private void handle(Message msg, boolean browse) throws JMSException {
        if (this.listener != null) {
            this.listener.onMessage(msg);
        } else if (browse) {
            if (this.verbose) {
                this.context.out.println("..." + String.valueOf(msg));
            }
            if (this.bytesAsText && msg instanceof BytesMessage) {
                BytesMessage bytesMessage = (BytesMessage)msg;
                long length = bytesMessage.getBodyLength();
                byte[] bytes = new byte[(int)length];
                bytesMessage.readBytes(bytes);
                this.context.out.println("Message:" + String.valueOf(msg));
            }
        } else if (this.verbose) {
            this.context.out.println("JMS Message ID:" + msg.getJMSMessageID());
            if (this.bytesAsText && msg instanceof BytesMessage) {
                BytesMessage bytesMessage = (BytesMessage)msg;
                long length = bytesMessage.getBodyLength();
                byte[] bytes = new byte[(int)length];
                bytesMessage.readBytes(bytes);
                this.context.out.println("Received a message with " + bytes.length);
            }
            if (msg instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)msg;
                String text = textMessage.getText();
                this.context.out.println("Received text sized at " + text.length());
            }
            if (msg instanceof ObjectMessage) {
                ObjectMessage objectMessage = (ObjectMessage)msg;
                Serializable obj = objectMessage.getObject();
                this.context.out.println("Received object " + obj.toString().length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void browse() {
        this.running = true;
        QueueBrowser consumer = null;
        String threadName = Thread.currentThread().getName();
        this.context.out.println(threadName + " trying to browse " + this.messageCount + " messages");
        try {
            Message msg;
            consumer = this.filter != null ? this.session.createBrowser((Queue)this.destination, this.filter) : this.session.createBrowser((Queue)this.destination);
            Enumeration enumBrowse = consumer.getEnumeration();
            while (enumBrowse.hasMoreElements() && (msg = (Message)enumBrowse.nextElement()) != null) {
                String string;
                PrintStream printStream = this.context.out;
                if (msg instanceof TextMessage) {
                    TextMessage tm = (TextMessage)msg;
                    string = tm.getText();
                } else {
                    string = msg.getJMSMessageID();
                }
                printStream.println(threadName + " browsing " + string);
                this.handle(msg, true);
                ++this.received;
                if ((long)this.received >= this.messageCount) break;
                if (this.sleep <= 0) continue;
                Thread.sleep(this.sleep);
            }
            consumer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.finished != null) {
                this.finished.countDown();
            }
            if (consumer != null) {
                this.context.out.println(threadName + " browsed: " + this.getReceived() + " messages");
                try {
                    consumer.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
        this.context.out.println(threadName + " Browser thread finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume() {
        this.running = true;
        MessageConsumer consumer = null;
        String threadName = Thread.currentThread().getName();
        this.context.out.println(threadName + " wait " + (String)(this.receiveTimeOut == -1 ? "forever" : this.receiveTimeOut + "ms") + " until " + this.messageCount + " messages are consumed");
        try {
            Destination destination;
            if (this.durable && (destination = this.destination) instanceof Topic) {
                Topic topic = (Topic)destination;
                consumer = this.filter != null ? this.session.createDurableSubscriber(topic, this.getName(), this.filter, false) : this.session.createDurableSubscriber(topic, this.getName());
            } else {
                consumer = this.filter != null ? this.session.createConsumer(this.destination, this.filter) : this.session.createConsumer(this.destination);
            }
            long tStart = System.currentTimeMillis();
            int count = 0;
            while (this.running && (long)this.received < this.messageCount) {
                Message msg = this.receiveTimeOut == -1 ? consumer.receive() : consumer.receive((long)this.receiveTimeOut);
                if (msg != null) {
                    if (this.verbose) {
                        String string;
                        PrintStream printStream = this.context.out;
                        if (msg instanceof TextMessage) {
                            TextMessage tm = (TextMessage)msg;
                            string = tm.getText();
                        } else {
                            string = msg.getJMSMessageID();
                        }
                        printStream.println(threadName + " Received " + string);
                    } else if (++count % 1000 == 0) {
                        this.context.out.println("Received " + count);
                    }
                    this.handle(msg, false);
                    ++this.received;
                } else if (this.breakOnNull) break;
                if (this.session.getTransacted()) {
                    if (this.batchSize > 0 && this.received > 0 && this.received % this.batchSize == 0) {
                        this.context.out.println(threadName + " Committing transaction: " + this.transactions++);
                        this.session.commit();
                    }
                } else if (this.session.getAcknowledgeMode() == 2 && msg != null && this.batchSize > 0 && this.received > 0 && this.received % this.batchSize == 0) {
                    this.context.out.println("Acknowledging last " + this.batchSize + " messages; messages so far = " + this.received);
                    msg.acknowledge();
                }
                if (this.sleep <= 0) continue;
                Thread.sleep(this.sleep);
            }
            try {
                this.session.commit();
            }
            catch (Throwable msg) {
                // empty catch block
            }
            this.context.out.println(threadName + " Consumed: " + this.getMessageCount() + " messages");
            long tEnd = System.currentTimeMillis();
            long elapsed = (tEnd - tStart) / 1000L;
            this.context.out.println(threadName + " Elapsed time in second : " + elapsed + " s");
            this.context.out.println(threadName + " Elapsed time in milli second : " + (tEnd - tStart) + " milli seconds");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.finished != null) {
                this.finished.countDown();
            }
            if (consumer != null) {
                this.context.out.println(threadName + " Consumed: " + this.getReceived() + " messages");
                try {
                    consumer.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
        this.context.out.println(threadName + " Consumer thread finished");
    }

    public int getReceived() {
        return this.received;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public ConsumerThread setDurable(boolean durable) {
        this.durable = durable;
        return this;
    }

    public ConsumerThread setMessageCount(long messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    public ConsumerThread setBreakOnNull(boolean breakOnNull) {
        this.breakOnNull = breakOnNull;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public ConsumerThread setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public long getMessageCount() {
        return this.messageCount;
    }

    public boolean isBreakOnNull() {
        return this.breakOnNull;
    }

    public int getReceiveTimeOut() {
        return this.receiveTimeOut;
    }

    public ConsumerThread setReceiveTimeOut(int receiveTimeOut) {
        this.receiveTimeOut = receiveTimeOut;
        return this;
    }

    public boolean isRunning() {
        return this.running;
    }

    public ConsumerThread setRunning(boolean running) {
        this.running = running;
        return this;
    }

    public int getSleep() {
        return this.sleep;
    }

    public ConsumerThread setSleep(int sleep) {
        this.sleep = sleep;
        return this;
    }

    public CountDownLatch getFinished() {
        return this.finished;
    }

    public ConsumerThread setFinished(CountDownLatch finished) {
        this.finished = finished;
        return this;
    }

    public boolean isBytesAsText() {
        return this.bytesAsText;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public ConsumerThread setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public ConsumerThread setBytesAsText(boolean bytesAsText) {
        this.bytesAsText = bytesAsText;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public ConsumerThread setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public boolean isBrowse() {
        return this.browse;
    }

    public ConsumerThread setBrowse(boolean browse) {
        this.browse = browse;
        return this;
    }

    public void setListener(MessageListener listener) {
        this.listener = listener;
    }
}

