/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import org.wildfly.clustering.function.DoublePredicate;
import org.wildfly.clustering.function.IntPredicate;
import org.wildfly.clustering.function.LongPredicate;

public interface Predicate<T>
extends java.util.function.Predicate<T> {
    public static final Predicate<?> ALWAYS = new SimplePredicate(true);
    public static final Predicate<?> NEVER = new SimplePredicate(false);

    default public Predicate<T> handle(final BiPredicate<T, RuntimeException> handler) {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                try {
                    return Predicate.this.test(value);
                }
                catch (RuntimeException e) {
                    return handler.test(value, e);
                }
            }
        };
    }

    default public <V> Predicate<V> compose(final Function<V, T> mapper) {
        return new Predicate<V>(){

            @Override
            public boolean test(V test) {
                return Predicate.this.test(mapper.apply(test));
            }
        };
    }

    default public DoublePredicate compose(final DoubleFunction<T> mapper) {
        return new DoublePredicate(){

            @Override
            public boolean test(double value) {
                return Predicate.this.test(mapper.apply(value));
            }
        };
    }

    default public IntPredicate compose(final IntFunction<T> mapper) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return Predicate.this.test(mapper.apply(value));
            }
        };
    }

    default public LongPredicate compose(final LongFunction<T> mapper) {
        return new LongPredicate(){

            @Override
            public boolean test(long value) {
                return Predicate.this.test(mapper.apply(value));
            }
        };
    }

    @Override
    default public Predicate<T> and(final java.util.function.Predicate<? super T> other) {
        return new Predicate<T>(){

            @Override
            public boolean test(T test) {
                return Predicate.this.test(test) && other.test(test);
            }
        };
    }

    @Override
    default public Predicate<T> negate() {
        return new Predicate<T>(){

            @Override
            public boolean test(T test) {
                return !Predicate.this.test(test);
            }
        };
    }

    @Override
    default public Predicate<T> or(final java.util.function.Predicate<? super T> other) {
        return new Predicate<T>(){

            @Override
            public boolean test(T test) {
                return Predicate.this.test(test) || other.test(test);
            }
        };
    }

    public static <T> Predicate<T> of(boolean result) {
        return result ? Predicate.always() : Predicate.never();
    }

    public static <T> Predicate<T> always() {
        return ALWAYS;
    }

    public static <T> Predicate<T> never() {
        return NEVER;
    }

    public static <T> Predicate<T> equal(T object) {
        return object == null ? Objects::isNull : object::equals;
    }

    public static <T> Predicate<T> same(final T object) {
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                return object == value;
            }
        };
    }

    public static <T> Predicate<T> not(Predicate<? super T> predicate) {
        return predicate.negate();
    }

    public static class SimplePredicate<T>
    implements Predicate<T> {
        private final boolean value;

        SimplePredicate(boolean value) {
            this.value = value;
        }

        @Override
        public boolean test(T value) {
            return this.value;
        }
    }
}

