/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr.cli;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.instmgr.cli.AbstractInstMgrCommand;
import org.wildfly.core.instmgr.cli.InstMgrActivator;

@CommandDefinition(name="channel-list", description="List channels subscribed to by the installation.", activator=InstMgrActivator.class)
public class ChannelListCommand
extends AbstractInstMgrCommand {
    @Override
    protected Operation buildOperation() {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-resource");
        op.get("include-runtime").set(true);
        return OperationBuilder.create((ModelNode)op, (boolean)true).build();
    }

    @Override
    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        CommandContext ctx = commandInvocation.getCommandContext();
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            ctx.printLine("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
            return CommandResult.FAILURE;
        }
        ModelNode response = this.executeOp(commandInvocation.getCommandContext(), this.host);
        ModelNode result = response.get("result");
        List channelsMn = result.get("channels").asListOrEmpty();
        if (channelsMn.isEmpty()) {
            ctx.printLine("No channels have been configured for this installation.");
            return CommandResult.SUCCESS;
        }
        ctx.printLine("-------");
        for (ModelNode channel : channelsMn) {
            ctx.printLine("# " + channel.get("name").asString());
            if (channel.get("manifest").isDefined()) {
                ModelNode manifestMn = channel.get("manifest");
                String manifest = manifestMn.get("gav").isDefined() ? manifestMn.get("gav").asString() : manifestMn.get("url").asString();
                ctx.printLine("  manifest: " + manifest);
            }
            if (channel.get("repositories").isDefined()) {
                ctx.printLine("  repositories:");
                List repositoriesMn = channel.get("repositories").asListOrEmpty();
                for (ModelNode repository : repositoriesMn) {
                    ctx.printLine("    id: " + repository.get("id").asString());
                    ctx.printLine("    url: " + repository.get("url").asString());
                }
            }
            ctx.printLine("-------");
        }
        return CommandResult.SUCCESS;
    }

    Set<String> getAllChannelNames(CommandContext ctx, String host) throws CommandException {
        HashSet<String> existingChannelNames = new HashSet<String>();
        ModelNode listCmdResponse = this.executeOp(ctx, host);
        if (listCmdResponse.hasDefined("result")) {
            ModelNode result = listCmdResponse.get("result");
            List channels = result.get("channels").asListOrEmpty();
            for (ModelNode channel : channels) {
                existingChannelNames.add(channel.get("name").asString());
            }
        }
        return existingChannelNames;
    }
}

