/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import org.infinispan.metrics.impl.BaseMemoryAdditionalMetrics;
import org.infinispan.metrics.impl.BaseMemoryPoolAdditionalMetrics;
import org.infinispan.metrics.impl.BaseOperatingSystemAdditionalMetrics;

@Deprecated(forRemoval=true, since="15.2")
class BaseAdditionalMetrics
implements MeterBinder {
    static final String PREFIX = "base.";

    BaseAdditionalMetrics() {
    }

    public void bindTo(MeterRegistry registry) {
        BaseAdditionalMetrics.bindClassLoaderMetrics(registry);
        new BaseOperatingSystemAdditionalMetrics().bindTo(registry);
        BaseAdditionalMetrics.bindGarbageCollectionMetrics(registry);
        BaseAdditionalMetrics.bindRuntimeMetrics(registry);
        new BaseMemoryAdditionalMetrics().bindTo(registry);
        new BaseMemoryPoolAdditionalMetrics().bindTo(registry);
        BaseAdditionalMetrics.bindThreadingMetrics(registry);
    }

    private static void bindClassLoaderMetrics(MeterRegistry registry) {
        ClassLoadingMXBean classLoadingBean = ManagementFactory.getClassLoadingMXBean();
        Gauge.builder((String)"base.classloader.loadedClasses.count", (Object)classLoadingBean, ClassLoadingMXBean::getLoadedClassCount).description("Displays the number of classes that are currently loaded in the Java virtual machine.").register(registry);
        FunctionCounter.builder((String)"base.classloader.loadedClasses.total", (Object)classLoadingBean, ClassLoadingMXBean::getTotalLoadedClassCount).description("Displays the total number of classes that have been loaded since the Java virtual machine has started execution.").register(registry);
        FunctionCounter.builder((String)"base.classloader.unloadedClasses.total", (Object)classLoadingBean, ClassLoadingMXBean::getUnloadedClassCount).description("Displays the total number of classes unloaded since the Java virtual machine has started execution.").register(registry);
    }

    private static void bindGarbageCollectionMetrics(MeterRegistry registry) {
        for (GarbageCollectorMXBean garbageCollectorBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            FunctionCounter.builder((String)"base.gc.total", (Object)garbageCollectorBean, GarbageCollectorMXBean::getCollectionCount).tags((Iterable)Tags.of((String)"name", (String)garbageCollectorBean.getName())).description("Displays the total number of collections that have occurred. This attribute lists -1 if the collection count is undefined for this collector.").register(registry);
            FunctionCounter.builder((String)"base.gc.time", (Object)garbageCollectorBean, GarbageCollectorMXBean::getCollectionTime).tags((Iterable)Tags.of((String)"name", (String)garbageCollectorBean.getName())).description("Displays the approximate accumulated collection elapsed time in milliseconds. This attribute displays -1 if the collection elapsed time is undefined for this collector. The Java virtual machine implementation may use a high resolution timer to measure the elapsed time. This attribute might display the same value even if the collection count has been incremented if the collection elapsed time is very short.").register(registry);
        }
    }

    private static void bindRuntimeMetrics(MeterRegistry registry) {
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        Gauge.builder((String)"base.jvm.uptime", (Object)runtimeBean, RuntimeMXBean::getUptime).description("Displays the uptime of the Java virtual machine.").register(registry);
    }

    private static void bindThreadingMetrics(MeterRegistry registry) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        Gauge.builder((String)"base.thread.count", (Object)threadBean, ThreadMXBean::getThreadCount).description("Displays the current thread count.").register(registry);
        Gauge.builder((String)"base.thread.daemon.count", (Object)threadBean, ThreadMXBean::getDaemonThreadCount).description("Displays the current number of live daemon threads.").register(registry);
        Gauge.builder((String)"base.thread.max.count", (Object)threadBean, ThreadMXBean::getPeakThreadCount).description("Displays the peak live thread count since the Java virtual machine started or peak was reset. This includes daemon and non-daemon threads.").register(registry);
        Gauge.builder((String)"base.thread.totalStarted", (Object)threadBean, ThreadMXBean::getTotalStartedThreadCount).description("Displays the total number of started threads.").register(registry);
    }
}

