/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.server.deployment.scanner.Attribute;
import org.jboss.as.server.deployment.scanner.DeploymentScannerDefinition;
import org.jboss.as.server.deployment.scanner.Element;
import org.jboss.as.server.deployment.scanner.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class DeploymentScannerParser_2_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    public static final DeploymentScannerParser_2_0 INSTANCE = new DeploymentScannerParser_2_0();

    DeploymentScannerParser_2_0() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode scanners = context.getModelNode();
        for (Property list : scanners.asPropertyList()) {
            ModelNode node = list.getValue();
            for (Property scanner : node.asPropertyList()) {
                String scannerName = scanner.getName();
                ModelNode configuration = scanner.getValue();
                writer.writeEmptyElement(Element.DEPLOYMENT_SCANNER.getLocalName());
                if (!"default".equals(scannerName)) {
                    writer.writeAttribute(Attribute.NAME.getLocalName(), scannerName);
                }
                DeploymentScannerDefinition.PATH.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                DeploymentScannerDefinition.RELATIVE_TO.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                DeploymentScannerDefinition.SCAN_ENABLED.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                DeploymentScannerDefinition.SCAN_INTERVAL.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                DeploymentScannerDefinition.AUTO_DEPLOY_ZIPPED.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                DeploymentScannerDefinition.AUTO_DEPLOY_EXPLODED.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                DeploymentScannerDefinition.AUTO_DEPLOY_XML.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                DeploymentScannerDefinition.DEPLOYMENT_TIMEOUT.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
                DeploymentScannerDefinition.RUNTIME_FAILURE_CAUSES_ROLLBACK.marshallAsAttribute(configuration, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "deployment-scanner");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case DEPLOYMENT_SCANNER_1_0: 
                case DEPLOYMENT_SCANNER_1_1: 
                case DEPLOYMENT_SCANNER_2_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case DEPLOYMENT_SCANNER: {
                            this.parseScanner(reader, address, list);
                            continue block6;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseScanner(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String name = "default";
        String path = null;
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        int attrCount = reader.getAttributeCount();
        block12: for (int i = 0; i < attrCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    DeploymentScannerDefinition.PATH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                case NAME: {
                    name = DeploymentScannerDefinition.NAME.parse(value, (XMLStreamReader)reader).asString();
                    continue block12;
                }
                case RELATIVE_TO: {
                    DeploymentScannerDefinition.RELATIVE_TO.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                case SCAN_INTERVAL: {
                    DeploymentScannerDefinition.SCAN_INTERVAL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                case SCAN_ENABLED: {
                    DeploymentScannerDefinition.SCAN_ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                case AUTO_DEPLOY_ZIPPED: {
                    DeploymentScannerDefinition.AUTO_DEPLOY_ZIPPED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                case AUTO_DEPLOY_EXPLODED: {
                    DeploymentScannerDefinition.AUTO_DEPLOY_EXPLODED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                case AUTO_DEPLOY_XML: {
                    DeploymentScannerDefinition.AUTO_DEPLOY_XML.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                case DEPLOYMENT_TIMEOUT: {
                    DeploymentScannerDefinition.DEPLOYMENT_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                case RUNTIME_FAILURE_CAUSES_ROLLBACK: {
                    DeploymentScannerDefinition.RUNTIME_FAILURE_CAUSES_ROLLBACK.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        if (path == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("path"));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operation.get("address").set(address).add("scanner", name);
        list.add(operation);
    }
}

