/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class SimpleMapAttributeDefinition
extends MapAttributeDefinition {
    private SimpleMapAttributeDefinition(Builder builder) {
        super(builder);
    }

    @Override
    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
        node.get("value-type").set(ModelType.STRING);
        node.get("expressions-allowed").set(new ModelNode(this.isAllowExpression()));
    }

    @Override
    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        node.get("value-type").set(ModelType.STRING);
        node.get("expressions-allowed").set(new ModelNode(this.isAllowExpression()));
    }

    @Override
    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        node.get("value-type").set(ModelType.STRING);
        node.get("expressions-allowed").set(new ModelNode(this.isAllowExpression()));
    }

    public static final class Builder
    extends MapAttributeDefinition.Builder<Builder, SimpleMapAttributeDefinition> {
        public Builder(String name, boolean allowNull) {
            super(name, allowNull);
        }

        public Builder(SimpleMapAttributeDefinition basis) {
            super(basis);
        }

        public Builder(PropertiesAttributeDefinition basis) {
            super(basis);
        }

        @Override
        public SimpleMapAttributeDefinition build() {
            if (this.elementValidator == null) {
                this.elementValidator = new ModelTypeValidator(ModelType.STRING, this.allowNull, this.allowExpression);
            }
            if (this.attributeMarshaller == null) {
                this.attributeMarshaller = new MapAttributeMarshaller();
            }
            return new SimpleMapAttributeDefinition(this);
        }
    }

    private static class MapAttributeMarshaller
    extends AttributeMarshaller {
        private MapAttributeMarshaller() {
        }

        @Override
        public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault) {
            return resourceModel.isDefined() && resourceModel.hasDefined(attribute.getName());
        }

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            resourceModel = resourceModel.get(attribute.getXmlName());
            writer.writeStartElement(attribute.getName());
            this.marshalToElement(resourceModel, writer);
            writer.writeEndElement();
        }

        private void marshalToElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
            if (!resourceModel.isDefined()) {
                return;
            }
            for (Property property : resourceModel.asPropertyList()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                writer.writeCharacters(property.getValue().asString());
                writer.writeEndElement();
            }
        }
    }
}

