/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.wildfly.security.manager.WildFlySecurityManager;

class SecurityActions {
    SecurityActions() {
    }

    static Subject getSubject() {
        return SecurityActions.getSubjectAction().getSubject();
    }

    private static GetSubjectAction getSubjectAction() {
        return WildFlySecurityManager.isChecking() ? GetSubjectAction.PRIVILEGED : GetSubjectAction.NON_PRIVILEGED;
    }

    private static interface GetSubjectAction {
        public static final GetSubjectAction NON_PRIVILEGED = new GetSubjectAction(){

            @Override
            public Subject getSubject() {
                return Subject.getSubject(AccessController.getContext());
            }
        };
        public static final GetSubjectAction PRIVILEGED = new GetSubjectAction(){

            @Override
            public Subject getSubject() {
                return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

                    @Override
                    public Subject run() {
                        return NON_PRIVILEGED.getSubject();
                    }
                });
            }
        };

        public Subject getSubject();
    }
}

