/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import javax.security.auth.Subject;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.remote.OperationAttachmentsProxy;
import org.jboss.as.controller.remote.OperationMessageHandlerProxy;
import org.jboss.as.controller.security.AccessMechanismPrincipal;
import org.jboss.as.controller.security.InetAddressPrincipal;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ModelControllerClientOperationHandler
implements ManagementRequestHandlerFactory {
    private final ModelController controller;
    private final ManagementChannelAssociation channelAssociation;
    private final Subject subject;

    public ModelControllerClientOperationHandler(ModelController controller, ManagementChannelAssociation channelAssociation) {
        this(controller, channelAssociation, null);
    }

    public ModelControllerClientOperationHandler(ModelController controller, ManagementChannelAssociation channelAssociation, Subject subject) {
        this.controller = controller;
        this.channelAssociation = channelAssociation;
        this.subject = subject;
    }

    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        switch (header.getOperationId()) {
            case 69: 
            case 70: {
                handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), null);
                return new ExecuteRequestHandler();
            }
            case 77: {
                return new CancelAsyncRequestHandler();
            }
        }
        return handlers.resolveNext();
    }

    private boolean sendPreparedResponse(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        String op = operation.get("operation").asString();
        int size = address.size();
        if (size == 0) {
            if (op.equals("reload")) {
                return true;
            }
            if (op.equals("composite")) {
                return false;
            }
            return false;
        }
        if (size == 1 && address.getLastElement().getKey().equals("host")) {
            return op.equals("reload");
        }
        return false;
    }

    private static class CancelAsyncRequestHandler
    implements ManagementRequestHandler<ModelNode, Void> {
        private CancelAsyncRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<Void> context) throws Exception {
                    ManagementResponseHeader response = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
                    FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)response);
                    try {
                        output.writeByte(36);
                        output.close();
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)output);
                    }
                }
            });
            resultHandler.cancel();
        }
    }

    private static class CompletedCallback {
        private volatile boolean completed;
        private final ManagementResponseHeader response;
        private final ManagementRequestContext<Void> responseContext;
        private final ActiveOperation.ResultHandler<ModelNode> resultHandler;

        private CompletedCallback(ManagementResponseHeader response, ManagementRequestContext<Void> responseContext, ActiveOperation.ResultHandler<ModelNode> resultHandler) {
            this.response = response;
            this.responseContext = responseContext;
            this.resultHandler = resultHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void sendResponse(ModelNode result) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            try {
                FlushableDataOutput output = this.responseContext.writeMessage((ManagementProtocolHeader)this.response);
                try {
                    output.write(100);
                    result.writeExternal((DataOutput)output);
                    output.writeByte(36);
                    output.close();
                }
                finally {
                    StreamUtils.safeClose((Closeable)output);
                }
                this.resultHandler.done((Object)result);
            }
            catch (IOException e) {
                this.resultHandler.failed((Exception)e);
            }
        }
    }

    class ExecuteRequestHandler
    implements ManagementRequestHandler<ModelNode, Void> {
        ExecuteRequestHandler() {
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            final ModelNode operation = new ModelNode();
            ProtocolUtils.expectHeader((DataInput)input, (int)97);
            operation.readExternal(input);
            ProtocolUtils.expectHeader((DataInput)input, (int)101);
            final int attachmentsLength = input.readInt();
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                public void execute(final ManagementRequestContext<Void> context) throws Exception {
                    final ManagementResponseHeader response = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
                    Subject useSubject = ModelControllerClientOperationHandler.this.subject;
                    if (ModelControllerClientOperationHandler.this.subject != null) {
                        PrivilegedAction<Subject> copyAction = new PrivilegedAction<Subject>(){

                            @Override
                            public Subject run() {
                                Subject subject = ModelControllerClientOperationHandler.this.subject;
                                Subject copySubject = new Subject();
                                copySubject.getPrincipals().addAll(subject.getPrincipals());
                                copySubject.getPrivateCredentials().addAll(subject.getPrivateCredentials());
                                copySubject.getPublicCredentials().addAll(subject.getPublicCredentials());
                                Collection principals = context.getChannel().getConnection().getPrincipals();
                                for (Principal principal : principals) {
                                    if (!(principal instanceof org.jboss.remoting3.security.InetAddressPrincipal)) continue;
                                    copySubject.getPrincipals().add(new InetAddressPrincipal(((org.jboss.remoting3.security.InetAddressPrincipal)principal).getInetAddress()));
                                    break;
                                }
                                copySubject.getPrincipals().add(new AccessMechanismPrincipal(AccessMechanism.NATIVE));
                                copySubject.setReadOnly();
                                return copySubject;
                            }
                        };
                        useSubject = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(copyAction) : (Subject)copyAction.run();
                    }
                    try {
                        Subject.doAs(useSubject, new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                CompletedCallback callback = new CompletedCallback(response, context, resultHandler);
                                ExecuteRequestHandler.this.doExecute(operation, attachmentsLength, (ManagementRequestContext<Void>)context, callback);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw e.getException();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doExecute(ModelNode operation, int attachmentsLength, ManagementRequestContext<Void> context, final CompletedCallback callback) {
            ModelNode headers = operation.get("operation-headers");
            headers.get("caller-type").set("user");
            if (headers.hasDefined("domain-uuid")) {
                headers.remove("domain-uuid");
            }
            if (headers.hasDefined("execute-for-coordinator")) {
                headers.remove("execute-for-coordinator");
            }
            ManagementRequestHeader header = (ManagementRequestHeader)ManagementRequestHeader.class.cast(context.getRequestHeader());
            int batchId = header.getBatchId();
            ModelNode result = new ModelNode();
            boolean sendPreparedOperation = ModelControllerClientOperationHandler.this.sendPreparedResponse(operation);
            ModelController.OperationTransactionControl transactionControl = sendPreparedOperation ? new ModelController.OperationTransactionControl(){

                @Override
                public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                    transaction.commit();
                    result.get("outcome").set("success");
                    result.get("result");
                    callback.sendResponse(result);
                }
            } : ModelController.OperationTransactionControl.COMMIT;
            OperationMessageHandlerProxy messageHandlerProxy = new OperationMessageHandlerProxy(ModelControllerClientOperationHandler.this.channelAssociation, batchId);
            OperationAttachmentsProxy attachmentsProxy = OperationAttachmentsProxy.create(ModelControllerClientOperationHandler.this.channelAssociation, batchId, attachmentsLength);
            try {
                ControllerLogger.ROOT_LOGGER.tracef("Executing client request %d(%d)", batchId, header.getRequestId());
                result.set(ModelControllerClientOperationHandler.this.controller.execute(operation, messageHandlerProxy, transactionControl, attachmentsProxy));
            }
            catch (Exception e) {
                ModelNode failure = new ModelNode();
                failure.get("outcome").set("failed");
                failure.get("failure-description").set(e.getClass().getName() + ":" + e.getMessage());
                result.set(failure);
                attachmentsProxy.shutdown(e);
            }
            finally {
                ControllerLogger.ROOT_LOGGER.tracef("Executed client request %d", batchId);
            }
            callback.sendResponse(result);
        }
    }
}

