/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;

class MarshallingUtil {
    private static final String FACTORY_NAME = "river";
    private static final MarshallingConfiguration configuration = new MarshallingConfiguration();

    MarshallingUtil() {
    }

    static Marshaller getMarshaller() throws IOException {
        return MarshallingUtil.getMarshallerFactory().createMarshaller(configuration);
    }

    static ByteOutput createByteOutput(final DataOutput dataOutput) {
        OutputStream outputStream = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                int byteToWrite = b & 0xFF;
                dataOutput.write(byteToWrite);
            }
        };
        return Marshalling.createByteOutput((OutputStream)outputStream);
    }

    static Unmarshaller getUnmarshaller() throws IOException {
        return MarshallingUtil.getMarshallerFactory().createUnmarshaller(configuration);
    }

    static ByteInput createByteInput(final DataInput dataInput) {
        InputStream is = new InputStream(){

            @Override
            public int read() throws IOException {
                try {
                    byte b = dataInput.readByte();
                    return b & 0xFF;
                }
                catch (EOFException eof) {
                    return -1;
                }
            }
        };
        return Marshalling.createByteInput((InputStream)is);
    }

    private static MarshallerFactory getMarshallerFactory() throws IOException {
        MarshallerFactory factory = Marshalling.getMarshallerFactory((String)FACTORY_NAME, (ClassLoader)MarshallingUtil.class.getClassLoader());
        return factory;
    }
}

