/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.rbac;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.access.AuthorizerConfiguration;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.permission.ManagementPermissionAuthorizer;
import org.jboss.as.controller.access.rbac.DefaultPermissionFactory;
import org.jboss.as.controller.access.rbac.RoleMapper;
import org.jboss.as.controller.access.rbac.RunAsRoleMapper;
import org.jboss.as.controller.access.rbac.StandardRole;

public final class StandardRBACAuthorizer
extends ManagementPermissionAuthorizer {
    private static final Set<String> STANDARD_ROLES;
    public static final Authorizer.AuthorizerDescription AUTHORIZER_DESCRIPTION;
    private final AuthorizerConfiguration configuration;
    private final DefaultPermissionFactory permissionFactory;
    private final RoleMapper roleMapper;

    public static StandardRBACAuthorizer create(AuthorizerConfiguration configuration, RoleMapper roleMapper) {
        RunAsRoleMapper runAsRoleMapper = new RunAsRoleMapper(roleMapper);
        DefaultPermissionFactory permissionFactory = new DefaultPermissionFactory(runAsRoleMapper, configuration);
        return new StandardRBACAuthorizer(configuration, permissionFactory, runAsRoleMapper);
    }

    private StandardRBACAuthorizer(AuthorizerConfiguration configuration, DefaultPermissionFactory permissionFactory, RoleMapper roleMapper) {
        super(permissionFactory, permissionFactory);
        this.configuration = configuration;
        this.permissionFactory = permissionFactory;
        configuration.registerScopedRoleListener(permissionFactory);
        this.roleMapper = roleMapper;
    }

    @Override
    public Set<String> getCallerRoles(Caller caller, Environment callEnvironment, Set<String> runAsroles) {
        return this.roleMapper.mapRoles(caller, callEnvironment, runAsroles);
    }

    @Override
    public Authorizer.AuthorizerDescription getDescription() {
        return AUTHORIZER_DESCRIPTION;
    }

    public void shutdown() {
        this.configuration.unregisterScopedRoleListener(this.permissionFactory);
    }

    static {
        LinkedHashSet<String> stdRoles = new LinkedHashSet<String>();
        for (StandardRole stdRole : StandardRole.values()) {
            stdRoles.add(stdRole.toString());
        }
        STANDARD_ROLES = stdRoles;
        AUTHORIZER_DESCRIPTION = new Authorizer.AuthorizerDescription(){

            @Override
            public boolean isRoleBased() {
                return true;
            }

            @Override
            public Set<String> getStandardRoles() {
                return STANDARD_ROLES;
            }
        };
    }
}

