/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.as.controller.access.Caller;
import org.wildfly.security.manager.WildFlySecurityManager;

class SecurityActions {
    private SecurityActions() {
    }

    static Caller getCaller(Caller currentCaller) {
        return SecurityActions.createCallerActions().getCaller(currentCaller);
    }

    private static CreateCallerActions createCallerActions() {
        return WildFlySecurityManager.isChecking() ? CreateCallerActions.PRIVILEGED : CreateCallerActions.NON_PRIVILEGED;
    }

    private static interface CreateCallerActions {
        public static final CreateCallerActions NON_PRIVILEGED = new CreateCallerActions(){

            @Override
            public Caller getCaller(Caller currentCaller) {
                AccessControlContext acc = AccessController.getContext();
                Subject subject = Subject.getSubject(acc);
                if (currentCaller == null || subject != currentCaller.getSubject()) {
                    if (subject != null) {
                        subject.setReadOnly();
                    }
                    return Caller.createCaller(subject);
                }
                return currentCaller;
            }
        };
        public static final CreateCallerActions PRIVILEGED = new CreateCallerActions(){

            @Override
            public Caller getCaller(final Caller currentCaller) {
                return AccessController.doPrivileged(new PrivilegedAction<Caller>(){

                    @Override
                    public Caller run() {
                        return NON_PRIVILEGED.getCaller(currentCaller);
                    }
                });
            }
        };

        public Caller getCaller(Caller var1);
    }
}

