/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.access.HostEffect;
import org.jboss.as.controller.access.ServerGroupEffect;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

class HostServerGroupTracker {
    private static final Set<String> UPLOAD_OPS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("upload-deployment-bytes", "upload-deployment-stream", "upload-deployment-url")));
    private boolean requiresMapping = true;
    private final Map<String, Set<String>> profilesToGroups = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> socketsToGroups = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> deploymentsToGroups = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> overlaysToGroups = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> hostsToGroups = new HashMap<String, Set<String>>();

    HostServerGroupTracker() {
    }

    HostServerGroupEffect getHostServerGroupEffects(PathAddress address, ModelNode operation, Resource root) {
        if (address.size() > 0) {
            PathElement firstElement = address.getElement(0);
            String type = firstElement.getKey();
            if ("host".equals(type)) {
                PathElement secondElement;
                String lvlone;
                String hostName = firstElement.getValue();
                if (address.size() > 1 && ("server-config".equals(lvlone = (secondElement = address.getElement(1)).getKey()) || "server".equals(lvlone))) {
                    Resource hostResource = root.getChild(firstElement);
                    if (hostResource != null) {
                        ModelNode model;
                        String serverGroup = null;
                        Resource serverConfig = hostResource.getChild(PathElement.pathElement("server-config", secondElement.getValue()));
                        if (serverConfig != null && (model = serverConfig.getModel()).hasDefined("group")) {
                            serverGroup = model.get("group").asString();
                        }
                        if (serverGroup == null && address.size() == 2 && "server-config".equals(lvlone) && "add".equals(operation.require("operation").asString())) {
                            serverGroup = operation.get("group").asString();
                        }
                        if (serverGroup != null) {
                            return HostServerGroupEffect.forServer(address, serverGroup, hostName);
                        }
                    }
                    return HostServerGroupEffect.forNonLocalHost(address, hostName);
                }
                return this.getHostEffect(address, hostName, root);
            }
            if ("profile".equals(type)) {
                return this.getDomainEffect(address, firstElement.getValue(), this.profilesToGroups, root);
            }
            if ("socket-binding-group".equals(type)) {
                return this.getDomainEffect(address, firstElement.getValue(), this.socketsToGroups, root);
            }
            if ("server-group".equals(type)) {
                return HostServerGroupEffect.forServerGroup(address, firstElement.getValue());
            }
            if ("deployment".equals(type)) {
                return this.getDomainEffect(address, firstElement.getValue(), this.deploymentsToGroups, root);
            }
            if ("deployment-overlay".equals(type)) {
                return this.getDomainEffect(address, firstElement.getValue(), this.overlaysToGroups, root);
            }
        } else {
            String opName = operation.require("operation").asString();
            if ("full-replace-deployment".equals(opName)) {
                if (operation.hasDefined("name")) {
                    return this.getDomainEffect(address, operation.get("name").asString(), this.deploymentsToGroups, root);
                }
            } else if (UPLOAD_OPS.contains(opName)) {
                return HostServerGroupEffect.forUnassignedDomain(address);
            }
        }
        return HostServerGroupEffect.forGlobal(address);
    }

    synchronized void invalidate() {
        this.requiresMapping = true;
        this.profilesToGroups.clear();
        this.socketsToGroups.clear();
        this.deploymentsToGroups.clear();
        this.overlaysToGroups.clear();
        this.hostsToGroups.clear();
    }

    private synchronized HostServerGroupEffect getDomainEffect(PathAddress address, String key, Map<String, Set<String>> map, Resource root) {
        Set<String> mapped;
        if (this.requiresMapping) {
            this.map(root);
            this.requiresMapping = false;
        }
        return (mapped = map.get(key)) != null ? HostServerGroupEffect.forDomain(address, mapped) : HostServerGroupEffect.forUnassignedDomain(address);
    }

    private synchronized HostServerGroupEffect getHostEffect(PathAddress address, String host, Resource root) {
        Set<String> mapped;
        if (this.requiresMapping) {
            this.map(root);
            this.requiresMapping = false;
        }
        return (mapped = this.hostsToGroups.get(host)) == null ? HostServerGroupEffect.forUnassignedHost(address, host) : HostServerGroupEffect.forHost(address, mapped, host);
    }

    private void map(Resource root) {
        for (Resource.ResourceEntry serverGroup : root.getChildren("server-group")) {
            String serverGroupName = serverGroup.getName();
            ModelNode serverGroupModel = serverGroup.getModel();
            String profile = serverGroupModel.require("profile").asString();
            HostServerGroupTracker.store(serverGroupName, profile, this.profilesToGroups);
            String socketBindingGroup = serverGroupModel.require("socket-binding-group").asString();
            HostServerGroupTracker.store(serverGroupName, socketBindingGroup, this.socketsToGroups);
            for (Resource.ResourceEntry deployment : serverGroup.getChildren("deployment")) {
                HostServerGroupTracker.store(serverGroupName, deployment.getName(), this.deploymentsToGroups);
            }
            for (Resource.ResourceEntry overlay : serverGroup.getChildren("deployment-overlay")) {
                HostServerGroupTracker.store(serverGroupName, overlay.getName(), this.overlaysToGroups);
            }
        }
        for (Resource.ResourceEntry host : root.getChildren("host")) {
            String hostName = host.getPathElement().getValue();
            for (Resource.ResourceEntry serverConfig : host.getChildren("server-config")) {
                ModelNode serverConfigModel = serverConfig.getModel();
                String serverGroupName = serverConfigModel.require("group").asString();
                HostServerGroupTracker.store(serverGroupName, hostName, this.hostsToGroups);
            }
        }
    }

    private static void store(String serverGroup, String key, Map<String, Set<String>> map) {
        Set<String> set = map.get(key);
        if (set == null) {
            set = new HashSet<String>();
            map.put(key, set);
        }
        set.add(serverGroup);
    }

    static class HostServerGroupEffect
    implements HostEffect,
    ServerGroupEffect {
        private static final Set<String> EMPTY = Collections.emptySet();
        private final PathAddress address;
        private final Set<String> serverGroupEffects;
        private final Set<String> hostEffects;
        private final boolean unassigned;

        private static HostServerGroupEffect forGlobal(PathAddress address) {
            return new HostServerGroupEffect(address, null, null, false);
        }

        private static HostServerGroupEffect forDomain(PathAddress address, Set<String> serverGroupEffects) {
            return new HostServerGroupEffect(address, serverGroupEffects == null ? EMPTY : serverGroupEffects, null, false);
        }

        private static HostServerGroupEffect forUnassignedDomain(PathAddress address) {
            return new HostServerGroupEffect(address, EMPTY, null, true);
        }

        private static HostServerGroupEffect forServerGroup(PathAddress address, String serverGroup) {
            return new HostServerGroupEffect(address, Collections.singleton(serverGroup), null, false);
        }

        private static HostServerGroupEffect forHost(PathAddress address, Set<String> serverGroupEffects, String hostEffect) {
            return new HostServerGroupEffect(address, serverGroupEffects, hostEffect, false);
        }

        private static HostServerGroupEffect forNonLocalHost(PathAddress address, String hostEffect) {
            return new HostServerGroupEffect(address, null, hostEffect, false);
        }

        private static HostServerGroupEffect forUnassignedHost(PathAddress address, String hostEffect) {
            return new HostServerGroupEffect(address, null, hostEffect, true);
        }

        static HostServerGroupEffect forServer(PathAddress address, String serverGroupEffect, String hostEffect) {
            assert (serverGroupEffect != null) : "serverGroupEffect is null";
            return new HostServerGroupEffect(address, Collections.singleton(serverGroupEffect), hostEffect, false);
        }

        private HostServerGroupEffect(PathAddress address, Set<String> serverGroupEffects, String hostEffect, boolean unassigned) {
            this.address = address;
            this.serverGroupEffects = serverGroupEffects;
            this.unassigned = unassigned;
            this.hostEffects = hostEffect == null ? null : Collections.singleton(hostEffect);
        }

        @Override
        public PathAddress getResourceAddress() {
            return this.address;
        }

        @Override
        public boolean isServerGroupEffectGlobal() {
            return this.serverGroupEffects == null;
        }

        @Override
        public boolean isServerGroupEffectUnassigned() {
            return this.unassigned;
        }

        @Override
        public Set<String> getAffectedServerGroups() {
            return this.serverGroupEffects;
        }

        @Override
        public boolean isHostEffectGlobal() {
            return this.hostEffects == null;
        }

        @Override
        public Set<String> getAffectedHosts() {
            return this.hostEffects;
        }
    }
}

