/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.constraint;

import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.constraint.AbstractConstraint;
import org.jboss.as.controller.access.constraint.AllowAllowNotConstraint;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.access.constraint.ConstraintFactory;
import org.jboss.as.controller.access.constraint.ScopingConstraint;
import org.jboss.as.controller.access.rbac.StandardRole;

public class AuditConstraint
extends AllowAllowNotConstraint {
    public static final ConstraintFactory FACTORY = new Factory();
    private static final AuditConstraint AUDIT = new AuditConstraint(true);
    private static final AuditConstraint NOT_AUDIT = new AuditConstraint(false);
    private static final AuditConstraint ALLOWS = new AuditConstraint(true, true);
    private static final AuditConstraint DISALLOWS = new AuditConstraint(false, true);

    private AuditConstraint(boolean isAudit) {
        super(isAudit);
    }

    private AuditConstraint(boolean allowsAudit, boolean allowsNonAudit) {
        super(allowsAudit, allowsNonAudit);
    }

    @Override
    public int compareTo(Constraint o) {
        if (o instanceof ScopingConstraint) {
            return 1;
        }
        return this.equals(o) ? 0 : -1;
    }

    @Override
    protected int internalCompare(AbstractConstraint other) {
        return other instanceof ScopingConstraint ? 1 : -1;
    }

    private static class Factory
    implements ConstraintFactory {
        private Factory() {
        }

        @Override
        public Constraint getStandardUserConstraint(StandardRole role, Action.ActionEffect actionEffect) {
            return role == StandardRole.AUDITOR || role == StandardRole.SUPERUSER ? ALLOWS : DISALLOWS;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetAttribute target) {
            return this.getRequiredConstraint(actionEffect, action, target.getTargetResource());
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetResource target) {
            return this.isAuditOperation(action) || this.isAuditResource(target) ? AUDIT : NOT_AUDIT;
        }

        private boolean isAuditOperation(Action action) {
            return false;
        }

        private boolean isAuditResource(TargetResource target) {
            return false;
        }
    }
}

