/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.EnumSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.access.constraint.management.AccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class AbstractAttributeDefinitionBuilder<BUILDER extends AbstractAttributeDefinitionBuilder, ATTRIBUTE extends AttributeDefinition> {
    protected final String name;
    protected final ModelType type;
    protected String xmlName;
    protected boolean allowNull;
    protected boolean allowExpression;
    protected ModelNode defaultValue;
    protected MeasurementUnit measurementUnit;
    protected String[] alternatives;
    protected String[] requires;
    protected ParameterCorrector corrector;
    protected ParameterValidator validator;
    protected boolean validateNull = true;
    protected int minSize = 0;
    protected int maxSize = Integer.MAX_VALUE;
    protected AttributeAccess.Flag[] flags;
    protected AttributeMarshaller attributeMarshaller = null;
    protected boolean resourceOnly = false;
    protected DeprecationData deprecated = null;
    protected AccessConstraintDefinition[] accessConstraints;

    public AbstractAttributeDefinitionBuilder(String attributeName, ModelType type) {
        this(attributeName, type, false);
    }

    public AbstractAttributeDefinitionBuilder(String attributeName, ModelType type, boolean allowNull) {
        this.name = attributeName;
        this.type = type;
        this.allowNull = allowNull;
        this.xmlName = this.name;
    }

    public AbstractAttributeDefinitionBuilder(AttributeDefinition basis) {
        this(null, basis);
    }

    public AbstractAttributeDefinitionBuilder(String attributeName, AttributeDefinition basis) {
        this.name = attributeName != null ? attributeName : basis.getName();
        this.type = basis.getType();
        this.xmlName = basis.getXmlName();
        this.allowNull = basis.isAllowNull();
        this.allowExpression = basis.isAllowExpression();
        this.defaultValue = basis.getDefaultValue();
        this.measurementUnit = basis.getMeasurementUnit();
        this.alternatives = basis.getAlternatives();
        this.requires = basis.getRequires();
        this.validator = basis.getValidator();
        EnumSet<AttributeAccess.Flag> basisFlags = basis.getFlags();
        this.flags = basisFlags.toArray(new AttributeAccess.Flag[basisFlags.size()]);
        this.attributeMarshaller = basis.getAttributeMarshaller();
    }

    public abstract ATTRIBUTE build();

    public BUILDER setXmlName(String xmlName) {
        this.xmlName = xmlName == null ? this.name : xmlName;
        return (BUILDER)this;
    }

    public BUILDER setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
        return (BUILDER)this;
    }

    public BUILDER setAllowExpression(boolean allowExpression) {
        this.allowExpression = allowExpression;
        return (BUILDER)this;
    }

    public BUILDER setDefaultValue(ModelNode defaultValue) {
        this.defaultValue = defaultValue == null || !defaultValue.isDefined() ? null : defaultValue;
        return (BUILDER)this;
    }

    public BUILDER setMeasurementUnit(MeasurementUnit unit) {
        this.measurementUnit = unit;
        return (BUILDER)this;
    }

    public BUILDER setCorrector(ParameterCorrector corrector) {
        this.corrector = corrector;
        return (BUILDER)this;
    }

    public BUILDER setValidator(ParameterValidator validator) {
        this.validator = validator;
        return (BUILDER)this;
    }

    public BUILDER setValidateNull(boolean validateNull) {
        this.validateNull = validateNull;
        return (BUILDER)this;
    }

    public BUILDER setAlternatives(String ... alternatives) {
        this.alternatives = alternatives;
        return (BUILDER)this;
    }

    public BUILDER addAlternatives(String ... alternatives) {
        if (this.alternatives == null) {
            this.alternatives = alternatives;
        } else {
            String[] newAlternatives = Arrays.copyOf(this.alternatives, this.alternatives.length + alternatives.length);
            System.arraycopy(alternatives, 0, newAlternatives, this.alternatives.length, alternatives.length);
            this.alternatives = newAlternatives;
        }
        return (BUILDER)this;
    }

    public BUILDER setRequires(String ... requires) {
        this.requires = requires;
        return (BUILDER)this;
    }

    public BUILDER setFlags(AttributeAccess.Flag ... flags) {
        this.flags = flags;
        return (BUILDER)this;
    }

    public BUILDER addFlag(AttributeAccess.Flag flag) {
        if (this.flags == null) {
            this.flags = new AttributeAccess.Flag[]{flag};
        } else {
            int i = this.flags.length;
            this.flags = Arrays.copyOf(this.flags, i + 1);
            this.flags[i] = flag;
        }
        return (BUILDER)this;
    }

    public BUILDER removeFlag(AttributeAccess.Flag flag) {
        if (!this.isFlagPresent(flag)) {
            return (BUILDER)this;
        }
        if (this.flags != null && this.flags.length > 0) {
            int length = this.flags.length;
            AttributeAccess.Flag[] newFlags = new AttributeAccess.Flag[length - 1];
            int k = 0;
            for (AttributeAccess.Flag flag1 : this.flags) {
                if (flag1 == flag) continue;
                newFlags[k] = flag1;
                ++k;
            }
            if (k != length - 1) {
                this.flags = newFlags;
            }
        }
        return (BUILDER)this;
    }

    protected boolean isFlagPresent(AttributeAccess.Flag flag) {
        if (this.flags == null) {
            return false;
        }
        for (AttributeAccess.Flag f : this.flags) {
            if (!f.equals((Object)flag)) continue;
            return true;
        }
        return false;
    }

    public BUILDER setStorageRuntime() {
        this.removeFlag(AttributeAccess.Flag.STORAGE_CONFIGURATION);
        return this.addFlag(AttributeAccess.Flag.STORAGE_RUNTIME);
    }

    public BUILDER setRestartAllServices() {
        this.removeFlag(AttributeAccess.Flag.RESTART_NONE);
        this.removeFlag(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES);
        this.removeFlag(AttributeAccess.Flag.RESTART_JVM);
        return this.addFlag(AttributeAccess.Flag.RESTART_ALL_SERVICES);
    }

    public BUILDER setRestartJVM() {
        this.removeFlag(AttributeAccess.Flag.RESTART_NONE);
        this.removeFlag(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES);
        this.removeFlag(AttributeAccess.Flag.RESTART_ALL_SERVICES);
        return this.addFlag(AttributeAccess.Flag.RESTART_JVM);
    }

    public BUILDER setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return (BUILDER)this;
    }

    public BUILDER setMinSize(int minSize) {
        this.minSize = minSize;
        return (BUILDER)this;
    }

    public BUILDER setAttributeMarshaller(AttributeMarshaller marshaller) {
        this.attributeMarshaller = marshaller;
        return (BUILDER)this;
    }

    public BUILDER setResourceOnly() {
        this.resourceOnly = true;
        return (BUILDER)this;
    }

    public BUILDER setDeprecated(ModelVersion since) {
        this.deprecated = new DeprecationData(since);
        return (BUILDER)this;
    }

    public BUILDER setAccessConstraints(AccessConstraintDefinition ... accessConstraints) {
        this.accessConstraints = accessConstraints;
        return (BUILDER)this;
    }

    public BUILDER addAccessConstraint(AccessConstraintDefinition accessConstraint) {
        if (this.accessConstraints == null) {
            this.accessConstraints = new AccessConstraintDefinition[]{accessConstraint};
        } else {
            this.accessConstraints = Arrays.copyOf(this.accessConstraints, this.accessConstraints.length + 1);
            this.accessConstraints[this.accessConstraints.length - 1] = accessConstraint;
        }
        return (BUILDER)this;
    }
}

