/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public abstract class SimplePersistentResourceDefinition
extends SimpleResourceDefinition
implements PersistentResourceDefinition {
    protected SimplePersistentResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver) {
        super(pathElement, descriptionResolver);
    }

    protected SimplePersistentResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(pathElement, descriptionResolver, addHandler, removeHandler);
    }

    protected SimplePersistentResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler, OperationEntry.Flag addRestartLevel, OperationEntry.Flag removeRestartLevel) {
        super(pathElement, descriptionResolver, addHandler, removeHandler, addRestartLevel, removeRestartLevel);
    }

    protected Map<String, AttributeDefinition> getAttributeMap() {
        HashMap<String, AttributeDefinition> res = new HashMap<String, AttributeDefinition>();
        for (AttributeDefinition def : this.getAttributes()) {
            res.put(def.getName(), def);
        }
        return res;
    }

    @Override
    public String getXmlElementName() {
        return this.getPathElement().getKey();
    }

    @Override
    public String getXmlWrapperElement() {
        return null;
    }

    @Override
    public List<? extends PersistentResourceDefinition> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        for (PersistentResourceDefinition persistentResourceDefinition : this.getChildren()) {
            resourceRegistration.registerSubModel(persistentResourceDefinition);
        }
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        ReloadRequiredWriteAttributeHandler handler = new ReloadRequiredWriteAttributeHandler(this.getAttributes());
        for (AttributeDefinition attr : this.getAttributes()) {
            resourceRegistration.registerReadWriteAttribute(attr, null, handler);
        }
    }

    @Override
    public void parse(XMLExtendedStreamReader reader, PathAddress parentAddress, List<ModelNode> list) throws XMLStreamException {
        if (this.getXmlWrapperElement() != null) {
            if (reader.getLocalName().equals(this.getXmlWrapperElement())) {
                if (reader.hasNext() && reader.nextTag() == 2) {
                    return;
                }
            } else {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
        boolean wildcard = this.getPathElement().isWildcard();
        String name = null;
        ModelNode op = Util.createAddOperation();
        Map<String, AttributeDefinition> attributes = this.getAttributeMap();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attributeName = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if (wildcard && "name".equals(attributeName)) {
                name = value;
                continue;
            }
            if (attributes.containsKey(attributeName)) {
                AttributeDefinition def = attributes.get(attributeName);
                if (def instanceof SimpleAttributeDefinition) {
                    ((SimpleAttributeDefinition)def).parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue;
                }
                if (def instanceof StringListAttributeDefinition) {
                    ((StringListAttributeDefinition)def).parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue;
                }
                throw new IllegalArgumentException("we should know how to handle " + def);
            }
            throw ParseUtils.unexpectedAttribute(reader, i);
        }
        if (wildcard && name == null) {
            throw ControllerMessages.MESSAGES.missingRequiredAttributes(new StringBuilder("name"), reader.getLocation());
        }
        PathElement path = wildcard ? PathElement.pathElement(this.getPathElement().getKey(), name) : this.getPathElement();
        PathAddress address = parentAddress.append(path);
        op.get("address").set(address.toModelNode());
        list.add(op);
        this.parseChildren(reader, address, list);
        if (this.getXmlWrapperElement() != null) {
            ParseUtils.requireNoContent(reader);
        }
    }

    private Map<String, PersistentResourceDefinition> getChildrenMap() {
        HashMap<String, PersistentResourceDefinition> res = new HashMap<String, PersistentResourceDefinition>();
        for (PersistentResourceDefinition persistentResourceDefinition : this.getChildren()) {
            if (persistentResourceDefinition.getXmlWrapperElement() != null) {
                res.put(persistentResourceDefinition.getXmlWrapperElement(), persistentResourceDefinition);
                continue;
            }
            res.put(persistentResourceDefinition.getXmlElementName(), persistentResourceDefinition);
        }
        return res;
    }

    public void parseChildren(XMLExtendedStreamReader reader, PathAddress parentAddress, List<ModelNode> list) throws XMLStreamException {
        if (this.getChildren().size() == 0) {
            ParseUtils.requireNoContent(reader);
        } else {
            Map<String, PersistentResourceDefinition> children = this.getChildrenMap();
            while (reader.hasNext() && reader.nextTag() != 2) {
                PersistentResourceDefinition child = children.get(reader.getLocalName());
                if (child != null) {
                    child.parse(reader, parentAddress, list);
                    continue;
                }
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    protected boolean useValueAsElementName() {
        return false;
    }

    @Override
    public void persist(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        this.persist(writer, model, null);
    }

    private void writeStartElement(XMLExtendedStreamWriter writer, String namespaceURI, String localName) throws XMLStreamException {
        if (namespaceURI != null) {
            writer.writeStartElement(namespaceURI, localName);
        } else {
            writer.writeStartElement(localName);
        }
    }

    public void startSubsystemElement(XMLExtendedStreamWriter writer, String namespaceURI, boolean empty) throws XMLStreamException {
        if (writer.getNamespaceContext().getPrefix(namespaceURI) == null) {
            writer.setDefaultNamespace(namespaceURI);
            if (empty) {
                writer.writeEmptyElement(Element.SUBSYSTEM.getLocalName());
            } else {
                writer.writeStartElement(Element.SUBSYSTEM.getLocalName());
            }
            writer.writeNamespace(null, namespaceURI);
        } else if (empty) {
            writer.writeEmptyElement(namespaceURI, Element.SUBSYSTEM.getLocalName());
        } else {
            writer.writeStartElement(namespaceURI, Element.SUBSYSTEM.getLocalName());
        }
    }

    public void persist(XMLExtendedStreamWriter writer, ModelNode model, String namespaceURI) throws XMLStreamException {
        boolean writeWrapper;
        boolean wildcard = this.getPathElement().isWildcard();
        ModelNode modelNode = model = wildcard ? model.get(this.getPathElement().getKey()) : model.get(this.getPathElement().getKeyValuePair());
        if (!model.isDefined() && !this.useValueAsElementName()) {
            return;
        }
        boolean isSubsystem = this.getPathElement().getKey().equals("subsystem");
        boolean bl = writeWrapper = this.getXmlWrapperElement() != null;
        if (writeWrapper) {
            this.writeStartElement(writer, namespaceURI, this.getXmlWrapperElement());
        }
        if (wildcard) {
            for (Property p : model.asPropertyList()) {
                if (this.useValueAsElementName()) {
                    this.writeStartElement(writer, namespaceURI, p.getName());
                } else {
                    this.writeStartElement(writer, namespaceURI, this.getXmlElementName());
                    writer.writeAttribute("name", p.getName());
                }
                for (AttributeDefinition def : this.getAttributes()) {
                    def.getAttributeMarshaller().marshallAsAttribute(def, p.getValue(), false, (XMLStreamWriter)writer);
                }
                this.persistChildren(writer, p.getValue());
                writer.writeEndElement();
            }
        } else {
            if (this.useValueAsElementName()) {
                this.writeStartElement(writer, namespaceURI, this.getPathElement().getValue());
            } else if (isSubsystem) {
                this.startSubsystemElement(writer, namespaceURI, this.getChildren().isEmpty());
            } else {
                this.writeStartElement(writer, namespaceURI, this.getXmlElementName());
            }
            for (AttributeDefinition def : this.getAttributes()) {
                def.getAttributeMarshaller().marshallAsAttribute(def, model, false, (XMLStreamWriter)writer);
            }
            this.persistChildren(writer, model);
            writer.writeEndElement();
        }
        if (writeWrapper) {
            writer.writeEndElement();
        }
    }

    public void persistChildren(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        for (PersistentResourceDefinition persistentResourceDefinition : this.getChildren()) {
            persistentResourceDefinition.persist(writer, model);
        }
    }
}

