/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ds.processors;

import java.util.List;
import java.util.Locale;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.vfs.VirtualFile;

public final class JdbcDriverDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String JAR_SUFFIX = ".jar";
    private static final String JDBC_DRIVER_CONFIG_FILE = "META-INF/services/java.sql.Driver";
    private static final String JDK_SECURITY_JGSS_ID = "jdk.security.jgss";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String deploymentName = deploymentUnit.getName().toLowerCase(Locale.ENGLISH);
        if (!deploymentName.endsWith(JAR_SUFFIX)) {
            return;
        }
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        boolean javaSqlDriverDetected = false;
        List resourceRoots = DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit);
        for (ResourceRoot resourceRoot : resourceRoots) {
            VirtualFile deploymentRoot = resourceRoot.getRoot();
            if (!deploymentRoot.getChild(JDBC_DRIVER_CONFIG_FILE).exists()) continue;
            javaSqlDriverDetected = true;
            break;
        }
        if (javaSqlDriverDetected) {
            moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)JDK_SECURITY_JGSS_ID).build());
        }
    }
}

