/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.configadmin.parser;

import java.util.List;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.configadmin.parser.ConfigAdminExtension;
import org.jboss.as.configadmin.parser.ConfigurationResource;
import org.jboss.as.configadmin.parser.Namespace;
import org.jboss.as.configadmin.parser.Namespace10;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class ConfigAdminParser
implements Namespace10,
XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    static ConfigAdminParser INSTANCE = new ConfigAdminParser();

    private ConfigAdminParser() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode model = context.getModelNode();
        if (model.hasDefined("configuration")) {
            ModelNode configuration = model.get("configuration");
            for (String pid : new TreeSet(configuration.keys())) {
                writer.writeStartElement(Namespace10.Element.CONFIGURATION.getLocalName());
                writer.writeAttribute(Namespace10.Attribute.PID.getLocalName(), pid);
                ConfigurationResource.ENTRIES.marshallAsElement(configuration.get(pid), (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{ConfigAdminExtension.SUBSYSTEM_PATH});
        operations.add(Util.createAddOperation((PathAddress)address));
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            block0 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                case VERSION_1_0: {
                    Namespace10.Element element = Namespace10.Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONFIGURATION: {
                            this.parseConfigurations(reader, address, operations);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
    }

    private void parseConfigurations(XMLExtendedStreamReader reader, PathAddress parent, List<ModelNode> operations) throws XMLStreamException {
        String pid = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Namespace10.Attribute.PID.getLocalName()})[0];
        ModelNode operation = Util.createAddOperation((PathAddress)parent.append("configuration", pid));
        operations.add(operation);
        block3: while (reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case VERSION_1_0: {
                    Namespace10.Element element = Namespace10.Element.forName(reader.getLocalName());
                    if (element == Namespace10.Element.PROPERTY) {
                        String[] array = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName()});
                        ConfigurationResource.ENTRIES.parseAndAddParameterElement(array[0], array[1], operation, reader);
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        continue block3;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

