/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.config.assembly;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.config.assembly.AttributeValue;
import org.jboss.as.config.assembly.Node;

class ElementNode
extends Node {
    private final ElementNode parent;
    private final String name;
    private final String namespace;
    private final Map<String, AttributeValue> attributes = new LinkedHashMap<String, AttributeValue>();
    private List<Node> children = new ArrayList<Node>();

    ElementNode(ElementNode parent, String name) {
        this(parent, name, parent.getNamespace());
    }

    ElementNode(ElementNode parent, String name, String namespace) {
        this.parent = parent;
        this.name = name;
        this.namespace = namespace == null ? namespace : (namespace.isEmpty() ? null : namespace);
    }

    String getNamespace() {
        return this.namespace;
    }

    String getName() {
        return this.name;
    }

    void addAttribute(String name, AttributeValue value) {
        this.attributes.put(name, value);
    }

    void addChild(Node child) {
        this.children.add(child);
    }

    Iterator<Node> getChildren() {
        return this.children.iterator();
    }

    ElementNode getParent() {
        return this.parent;
    }

    Iterator<Node> iterateChildren() {
        return this.children.iterator();
    }

    String getAttributeValue(String name) {
        AttributeValue av = this.attributes.get(name);
        if (av == null) {
            return null;
        }
        return av.getValue();
    }

    String getAttributeValue(String name, String defaultValue) {
        String s = this.getAttributeValue(name);
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    @Override
    void marshall(XMLStreamWriter writer) throws XMLStreamException {
        boolean empty = this.isEmpty();
        NamespaceContext context = writer.getNamespaceContext();
        String prefix = writer.getNamespaceContext().getPrefix(this.namespace);
        if (prefix == null) {
            writer.setDefaultNamespace(this.namespace);
            if (empty) {
                writer.writeEmptyElement(this.name);
            } else {
                writer.writeStartElement(this.name);
            }
            writer.writeNamespace(null, this.namespace);
        } else if (empty) {
            writer.writeEmptyElement(this.namespace, this.name);
        } else {
            writer.writeStartElement(this.namespace, this.name);
        }
        for (Map.Entry<String, AttributeValue> attr : this.attributes.entrySet()) {
            writer.writeAttribute(attr.getKey(), attr.getValue().getValue());
        }
        for (Node child : this.children) {
            child.marshall(writer);
        }
        if (!empty) {
            writer.writeEndElement();
        }
    }

    private boolean isEmpty() {
        if (this.children.isEmpty()) {
            return true;
        }
        for (Node child : this.children) {
            if (!child.hasContent()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Element(name=" + this.name + ",ns=" + this.namespace + ")";
    }
}

