/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.adapter;

import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.Trigger;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jboss.as.ee.concurrent.ManagedExecutorRuntimeStats;
import org.jboss.as.ee.concurrent.WildFlyManagedScheduledExecutorService;
import org.jboss.as.ee.concurrent.WildFlyManagedThreadFactory;
import org.jboss.as.ee.concurrent.adapter.AbstractManagedExecutorServiceAdapter;

public class ManagedScheduledExecutorServiceAdapter
extends AbstractManagedExecutorServiceAdapter
implements WildFlyManagedScheduledExecutorService {
    private final WildFlyManagedScheduledExecutorService executorService;

    public ManagedScheduledExecutorServiceAdapter(WildFlyManagedScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    public WildFlyManagedScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public WildFlyManagedThreadFactory getWildFlyManagedThreadFactory() {
        return this.executorService.getWildFlyManagedThreadFactory();
    }

    public void terminateHungTasks() {
        this.executorService.terminateHungTasks();
    }

    public ManagedExecutorRuntimeStats getRuntimeStats() {
        return this.executorService.getRuntimeStats();
    }

    public <U> CompletableFuture<U> completedFuture(U u) {
        return this.executorService.completedFuture(u);
    }

    public <U> CompletionStage<U> completedStage(U u) {
        return this.executorService.completedStage(u);
    }

    public <T> CompletableFuture<T> copy(CompletableFuture<T> completableFuture) {
        return this.executorService.copy(completableFuture);
    }

    public <T> CompletionStage<T> copy(CompletionStage<T> completionStage) {
        return this.executorService.copy(completionStage);
    }

    public <U> CompletableFuture<U> failedFuture(Throwable throwable) {
        return this.executorService.failedFuture(throwable);
    }

    public <U> CompletionStage<U> failedStage(Throwable throwable) {
        return this.executorService.failedStage(throwable);
    }

    public ContextService getContextService() {
        return this.executorService.getContextService();
    }

    public <U> CompletableFuture<U> newIncompleteFuture() {
        return this.executorService.newIncompleteFuture();
    }

    public CompletableFuture<Void> runAsync(Runnable runnable) {
        return this.executorService.runAsync(runnable);
    }

    public <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return this.executorService.supplyAsync(supplier);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.executorService.submit(task, result);
    }

    public Future<?> submit(Runnable task) {
        return this.executorService.submit(task);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executorService.invokeAll(tasks);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.invokeAll(tasks, timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.executorService.invokeAny(tasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.executorService.invokeAny(tasks, timeout, unit);
    }

    public void execute(Runnable command) {
        this.executorService.execute(command);
    }

    public ScheduledFuture<?> schedule(Runnable runnable, Trigger trigger) {
        return this.executorService.schedule(runnable, trigger);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, Trigger trigger) {
        return this.executorService.schedule(callable, trigger);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executorService.schedule(command, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.executorService.schedule(callable, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executorService.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executorService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }
}

