/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.weld.annotated.slim;

import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class AnnotatedParameterMarshaller<X, T extends SlimAnnotatedType<X>, C extends AnnotatedConstructor<X>, M extends AnnotatedMethod<X>, P extends AnnotatedParameter<X>>
implements ProtoStreamMarshaller<P> {
    private static final int CONSTRUCTOR_INDEX = 1;
    private static final int METHOD_INDEX = 2;
    private static final int POSITION_INDEX = 3;
    private final Class<P> targetClass;
    private final Class<C> constructorClass;
    private final Class<M> methodClass;

    public AnnotatedParameterMarshaller(Class<P> targetClass, Class<C> constructorClass, Class<M> methodClass) {
        this.targetClass = targetClass;
        this.constructorClass = constructorClass;
        this.methodClass = methodClass;
    }

    public Class<P> getJavaClass() {
        return this.targetClass;
    }

    public P readFrom(ProtoStreamReader reader) throws IOException {
        AnnotatedCallable callable = null;
        int position = 0;
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    callable = (AnnotatedCallable)reader.readObject(this.constructorClass);
                    continue block5;
                }
                case 2: {
                    callable = (AnnotatedCallable)reader.readObject(this.methodClass);
                    continue block5;
                }
                case 3: {
                    position = reader.readUInt32();
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        return (P)((AnnotatedParameter)this.targetClass.cast(callable.getParameters().get(position)));
    }

    public void writeTo(ProtoStreamWriter writer, P parameter) throws IOException {
        AnnotatedCallable callable = parameter.getDeclaringCallable();
        writer.writeObject(callable.getJavaMember() instanceof Constructor ? 1 : 2, (Object)callable);
        int index = parameter.getPosition();
        if (index > 0) {
            writer.writeUInt32(3, index);
        }
    }
}

