/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.BatchContext;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.SimpleSessionConfig;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class DistributableSession
implements io.undertow.server.session.Session {
    private static final Set<String> AUTO_REAUTHENTICATING_MECHANISMS = Set.of("BASIC", "DIGEST", "CLIENT_CERT");
    static final String WEB_SOCKET_CHANNELS_ATTRIBUTE = "io.undertow.websocket.current-connections";
    private static final Set<String> LOCAL_CONTEXT_ATTRIBUTES = Set.of("io.undertow.websocket.current-connections");
    private final UndertowSessionManager manager;
    private final SuspendedBatch suspendedBatch;
    private final AtomicReference<Consumer<HttpServerExchange>> closeTask;
    private final Instant startTime;
    private final RecordableSessionManagerStatistics statistics;
    private volatile Map.Entry<Session<Map<String, Object>>, SessionConfig> entry;

    public DistributableSession(UndertowSessionManager manager, Session<Map<String, Object>> session, SessionConfig config, SuspendedBatch suspendedBatch, Consumer<HttpServerExchange> closeTask, RecordableSessionManagerStatistics statistics) {
        this.manager = manager;
        this.entry = Map.entry(session, config);
        this.suspendedBatch = suspendedBatch;
        this.closeTask = new AtomicReference<Consumer<HttpServerExchange>>(closeTask);
        this.startTime = session.getMetaData().isNew() ? session.getMetaData().getCreationTime() : Instant.now();
        this.statistics = statistics;
    }

    public SessionManager getSessionManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDone(HttpServerExchange exchange) {
        Consumer closeTask = this.closeTask.getAndSet(null);
        if (closeTask != null) {
            try (Batch batch = this.suspendedBatch.resume();
                 Session<Map<String, Object>> session = this.entry.getKey();){
                if (session.isValid()) {
                    session.getMetaData().setLastAccess(this.startTime, Instant.now());
                }
            }
            catch (Throwable e) {
                UndertowClusteringLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
            }
            finally {
                this.entry = Map.entry(this.entry.getKey(), new SimpleSessionConfig(this.entry.getKey().getId()));
                closeTask.accept(exchange);
            }
        }
    }

    public String getId() {
        return this.entry.getKey().getId();
    }

    public long getCreationTime() {
        Session<Map<String, Object>> session = this.entry.getKey();
        try {
            return this.entry.getKey().getMetaData().getCreationTime().toEpochMilli();
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null, session);
            throw e;
        }
    }

    public long getLastAccessedTime() {
        Session<Map<String, Object>> session = this.entry.getKey();
        try {
            SessionMetaData metaData = session.getMetaData();
            return Optional.ofNullable(metaData.getLastAccessStartTime()).orElseGet(() -> ((SessionMetaData)metaData).getCreationTime()).toEpochMilli();
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null, session);
            throw e;
        }
    }

    public int getMaxInactiveInterval() {
        Session<Map<String, Object>> session = this.entry.getKey();
        try {
            return (int)session.getMetaData().getTimeout().getSeconds();
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null, session);
            throw e;
        }
    }

    public void setMaxInactiveInterval(int interval) {
        Session<Map<String, Object>> session = this.entry.getKey();
        try {
            session.getMetaData().setTimeout(Duration.ofSeconds(interval));
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null, session);
            throw e;
        }
    }

    public Set<String> getAttributeNames() {
        Session<Map<String, Object>> session = this.entry.getKey();
        try {
            return session.getAttributes().keySet();
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null, session);
            throw e;
        }
    }

    public Object getAttribute(String name) {
        Session<Map<String, Object>> session = this.entry.getKey();
        try {
            if (CachedAuthenticatedSessionHandler.ATTRIBUTE_NAME.equals(name)) {
                AuthenticatedSessionManager.AuthenticatedSession auth = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttributes().get(name);
                return auth != null ? auth : ((Map)session.getContext()).get(name);
            }
            if (LOCAL_CONTEXT_ATTRIBUTES.contains(name)) {
                return ((Map)session.getContext()).get(name);
            }
            return session.getAttributes().get(name);
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null, session);
            throw e;
        }
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.removeAttribute(name);
        }
        Session<Map<String, Object>> session = this.entry.getKey();
        try {
            if (CachedAuthenticatedSessionHandler.ATTRIBUTE_NAME.equals(name)) {
                AuthenticatedSessionManager.AuthenticatedSession auth = (AuthenticatedSessionManager.AuthenticatedSession)value;
                return AUTO_REAUTHENTICATING_MECHANISMS.contains(auth.getMechanism()) ? ((Map)session.getContext()).put(name, auth) : session.getAttributes().put(name, auth);
            }
            if (LOCAL_CONTEXT_ATTRIBUTES.contains(name)) {
                return ((Map)session.getContext()).put(name, value);
            }
            Object old = session.getAttributes().put(name, value);
            if (old == null) {
                this.manager.getSessionListeners().attributeAdded((io.undertow.server.session.Session)this, name, value);
            } else if (old != value) {
                this.manager.getSessionListeners().attributeUpdated((io.undertow.server.session.Session)this, name, value, old);
            }
            return old;
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null, session);
            throw e;
        }
    }

    public Object removeAttribute(String name) {
        Session<Map<String, Object>> session = this.entry.getKey();
        try {
            if (CachedAuthenticatedSessionHandler.ATTRIBUTE_NAME.equals(name)) {
                AuthenticatedSessionManager.AuthenticatedSession auth = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttributes().remove(name);
                return auth != null ? auth : ((Map)session.getContext()).remove(name);
            }
            if (LOCAL_CONTEXT_ATTRIBUTES.contains(name)) {
                return ((Map)session.getContext()).remove(name);
            }
            Object old = session.getAttributes().remove(name);
            if (old != null) {
                this.manager.getSessionListeners().attributeRemoved((io.undertow.server.session.Session)this, name, old);
            }
            return old;
        }
        catch (IllegalStateException e) {
            this.closeIfInvalid(null, session);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(HttpServerExchange exchange) {
        Consumer closeTask;
        Map.Entry<Session<Map<String, Object>>, SessionConfig> entry = this.entry;
        Session<Map<String, Object>> session = entry.getKey();
        if (session.isValid()) {
            this.manager.getSessionListeners().sessionDestroyed((io.undertow.server.session.Session)this, exchange, SessionListener.SessionDestroyedReason.INVALIDATED);
            for (Map.Entry attributesEntry : session.getAttributes().entrySet()) {
                this.manager.getSessionListeners().attributeRemoved((io.undertow.server.session.Session)this, (String)attributesEntry.getKey(), attributesEntry.getValue());
            }
            if (this.statistics != null) {
                this.statistics.getInactiveSessionRecorder().record((ImmutableSessionMetaData)session.getMetaData());
            }
        }
        if ((closeTask = (Consumer)this.closeTask.getAndSet(null)) != null) {
            try (Batch batch = this.suspendedBatch.resume();){
                try (Session<Map<String, Object>> validSession = session;){
                    session.invalidate();
                }
                finally {
                    if (exchange != null) {
                        String id = session.getId();
                        entry.getValue().clearSession(exchange, id);
                    }
                }
            }
            finally {
                closeTask.accept(exchange);
            }
        }
    }

    public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
        Session<Map<String, Object>> oldSession = this.entry.getKey();
        org.wildfly.clustering.session.SessionManager<Map<String, Object>> manager = this.manager.getSessionManager();
        String id = (String)manager.getIdentifierFactory().get();
        try (BatchContext context = this.suspendedBatch.resumeWithContext();){
            Session newSession = manager.createSession(id);
            try {
                newSession.getAttributes().putAll(oldSession.getAttributes());
                SessionMetaData oldMetaData = oldSession.getMetaData();
                SessionMetaData newMetaData = newSession.getMetaData();
                newMetaData.setTimeout(oldMetaData.getTimeout());
                Instant lastAccessStartTime = oldMetaData.getLastAccessStartTime();
                Instant lastAccessEndTime = oldMetaData.getLastAccessEndTime();
                if (lastAccessStartTime != null && lastAccessEndTime != null) {
                    newMetaData.setLastAccess(oldSession.getMetaData().getLastAccessStartTime(), oldSession.getMetaData().getLastAccessEndTime());
                }
                ((Map)newSession.getContext()).putAll((Map)oldSession.getContext());
                oldSession.invalidate();
                config.setSessionId(exchange, id);
                this.entry = Map.entry(newSession, config);
            }
            catch (IllegalStateException e) {
                this.closeIfInvalid(exchange, oldSession);
                newSession.invalidate();
                throw e;
            }
        }
        if (!oldSession.isValid()) {
            this.manager.getSessionListeners().sessionIdChanged((io.undertow.server.session.Session)this, oldSession.getId());
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIfInvalid(HttpServerExchange exchange, Session<Map<String, Object>> session) {
        Consumer closeTask;
        if (!session.isValid() && (closeTask = (Consumer)this.closeTask.getAndSet(null)) != null) {
            try {
                session.close();
            }
            finally {
                closeTask.accept(exchange);
            }
        }
    }
}

