/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Map;
import org.infinispan.Cache;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactoryService;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.RetryingCacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.marshalling.MarshalledValue;
import org.jboss.as.clustering.marshalling.MarshalledValueFactory;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.jboss.as.clustering.marshalling.SimpleMarshalledValueFactory;
import org.jboss.as.clustering.marshalling.SimpleMarshallingContext;
import org.jboss.as.clustering.marshalling.SimpleMarshallingContextFactory;
import org.jboss.as.clustering.marshalling.VersionedMarshallingConfiguration;
import org.jboss.modules.Module;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.AffinityIdentifierFactory;
import org.wildfly.clustering.web.infinispan.InfinispanBatcher;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManager;
import org.wildfly.clustering.web.infinispan.session.MarshalledValueSessionAttributeMarshaller;
import org.wildfly.clustering.web.infinispan.session.SessionAttributeMarshallingContext;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionFactory;
import org.wildfly.clustering.web.infinispan.session.coarse.SessionAttributesCacheKey;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionFactory;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeCacheKey;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;

public class InfinispanSessionManagerFactory
extends AbstractService<SessionManagerFactory>
implements SessionManagerFactory {
    private final SessionManagerConfiguration config;
    private final CacheInvoker invoker = new RetryingCacheInvoker(new int[]{10, 100});
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final InjectedValue<KeyAffinityServiceFactory> affinityFactory = new InjectedValue();

    public static ServiceBuilder<SessionManagerFactory> build(ServiceTarget target, ServiceName name, String containerName, String cacheName, SessionManagerConfiguration config) {
        InfinispanSessionManagerFactory factory = new InfinispanSessionManagerFactory(config);
        return target.addService(name, (Service)factory).addDependency(CacheService.getServiceName((String)containerName, (String)cacheName), Cache.class, factory.cache).addDependency(KeyAffinityServiceFactoryService.getServiceName((String)containerName), KeyAffinityServiceFactory.class, factory.affinityFactory);
    }

    private InfinispanSessionManagerFactory(SessionManagerConfiguration config) {
        this.config = config;
    }

    public SessionManagerFactory getValue() {
        return this;
    }

    public <L> SessionManager<L> createSessionManager(SessionContext context, IdentifierFactory<String> identifierFactory, LocalContextFactory<L> localContextFactory) {
        InfinispanBatcher batcher = new InfinispanBatcher((Cache)this.cache.getValue());
        AffinityIdentifierFactory<String> factory = new AffinityIdentifierFactory<String>(identifierFactory, (Cache)this.cache.getValue(), (KeyAffinityServiceFactory)this.affinityFactory.getValue());
        return new InfinispanSessionManager(context, factory, (Cache)this.cache.getValue(), this.getSessionFactory(context, localContextFactory), batcher, this.config.getMaxActiveSessions());
    }

    private <L> SessionFactory<?, L> getSessionFactory(SessionContext context, LocalContextFactory<L> localContextFactory) {
        Module module = this.config.getModule();
        SimpleMarshallingContext marshallingContext = new SimpleMarshallingContextFactory().createMarshallingContext((VersionedMarshallingConfiguration)new SessionAttributeMarshallingContext(module), (ClassLoader)module.getClassLoader());
        SimpleMarshalledValueFactory factory = new SimpleMarshalledValueFactory((MarshallingContext)marshallingContext);
        switch (this.config.getAttributePersistenceStrategy()) {
            case FINE: {
                Cache sessionCache = (Cache)this.cache.getValue();
                Cache attributeCache = (Cache)this.cache.getValue();
                MarshalledValueSessionAttributeMarshaller marshaller = new MarshalledValueSessionAttributeMarshaller((MarshalledValueFactory<SimpleMarshallingContext>)factory, marshallingContext);
                return new FineSessionFactory<L>(sessionCache, (Cache<SessionAttributeCacheKey, MarshalledValue<Object, MarshallingContext>>)attributeCache, this.invoker, context, marshaller, localContextFactory);
            }
            case COARSE: {
                Cache sessionCache = (Cache)this.cache.getValue();
                Cache attributesCache = (Cache)this.cache.getValue();
                MarshalledValueSessionAttributeMarshaller marshaller = new MarshalledValueSessionAttributeMarshaller((MarshalledValueFactory<SimpleMarshallingContext>)factory, marshallingContext);
                return new CoarseSessionFactory<L>(sessionCache, (Cache<SessionAttributesCacheKey, MarshalledValue<Map<String, Object>, MarshallingContext>>)attributesCache, this.invoker, context, marshaller, localContextFactory);
            }
        }
        throw new IllegalStateException();
    }
}

