/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Map;
import org.infinispan.Cache;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.RetryingCacheInvoker;
import org.jboss.as.clustering.marshalling.MarshalledValue;
import org.jboss.as.clustering.marshalling.MarshalledValueFactory;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.jboss.as.clustering.marshalling.SimpleMarshalledValueFactory;
import org.jboss.as.clustering.marshalling.VersionedMarshallingConfiguration;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.InfinispanWebMessages;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManager;
import org.wildfly.clustering.web.infinispan.session.MarshalledValueSessionAttributeMarshaller;
import org.wildfly.clustering.web.infinispan.session.SessionAttributeMarshallingContext;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionFactory;
import org.wildfly.clustering.web.infinispan.session.coarse.SessionAttributesCacheKey;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionFactory;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeCacheKey;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionIdentifierFactory;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerFactory;

public class InfinispanSessionManagerFactory
extends AbstractService<SessionManagerFactory>
implements SessionManagerFactory {
    private final SessionAttributeMarshallingContext context;
    private final JBossWebMetaData metaData;
    private final CacheInvoker invoker = new RetryingCacheInvoker(new int[]{10, 100});
    private final Value<Cache> cache;
    private final Value<KeyAffinityServiceFactory> affinityFactory;
    private final Value<Registry> registry;

    public InfinispanSessionManagerFactory(Module module, JBossWebMetaData metaData, Value<Cache> cache, Value<KeyAffinityServiceFactory> affinityFactory, Value<Registry> registry) {
        this.context = new SessionAttributeMarshallingContext(module);
        this.cache = cache;
        this.affinityFactory = affinityFactory;
        this.registry = registry;
        this.metaData = metaData;
    }

    public SessionManagerFactory getValue() {
        return this;
    }

    public <L> SessionManager<L> createSessionManager(SessionContext context, SessionIdentifierFactory identifierFactory, LocalContextFactory<L> localContextFactory) {
        return new InfinispanSessionManager(context, identifierFactory, (Cache)this.cache.getValue(), this.getSessionFactory(context, localContextFactory), (KeyAffinityServiceFactory)this.affinityFactory.getValue(), (Registry<String, Void>)((Registry)this.registry.getValue()), this.metaData);
    }

    private <L> SessionFactory<?, L> getSessionFactory(SessionContext context, LocalContextFactory<L> localContextFactory) {
        MarshallingContext marshallingContext = new MarshallingContext((VersionedMarshallingConfiguration)this.context);
        SimpleMarshalledValueFactory factory = new SimpleMarshalledValueFactory(marshallingContext);
        switch (this.metaData.getReplicationConfig().getReplicationGranularity()) {
            case ATTRIBUTE: {
                Cache sessionCache = (Cache)this.cache.getValue();
                Cache attributeCache = (Cache)this.cache.getValue();
                MarshalledValueSessionAttributeMarshaller<Object, MarshallingContext> marshaller = new MarshalledValueSessionAttributeMarshaller<Object, MarshallingContext>((MarshalledValueFactory<MarshallingContext>)factory, marshallingContext);
                return new FineSessionFactory<L>(sessionCache, (Cache<SessionAttributeCacheKey, MarshalledValue<Object, MarshallingContext>>)attributeCache, this.invoker, context, marshaller, localContextFactory);
            }
            case SESSION: {
                Cache sessionCache = (Cache)this.cache.getValue();
                Cache attributesCache = (Cache)this.cache.getValue();
                MarshalledValueSessionAttributeMarshaller<Map<String, Object>, MarshallingContext> marshaller = new MarshalledValueSessionAttributeMarshaller<Map<String, Object>, MarshallingContext>((MarshalledValueFactory<MarshallingContext>)factory, marshallingContext);
                return new CoarseSessionFactory<L>(sessionCache, (Cache<SessionAttributesCacheKey, MarshalledValue<Map<String, Object>, MarshallingContext>>)attributesCache, this.invoker, context, marshaller, localContextFactory);
            }
        }
        throw InfinispanWebMessages.MESSAGES.unknownReplicationGranularity(this.metaData.getReplicationConfig().getReplicationGranularity());
    }
}

