/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.coarse;

import java.util.Map;
import org.wildfly.clustering.web.infinispan.CacheMutator;
import org.wildfly.clustering.web.infinispan.Mutator;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseImmutableSessionAttributes;
import org.wildfly.clustering.web.session.SessionAttributes;

public class CoarseSessionAttributes
extends CoarseImmutableSessionAttributes
implements SessionAttributes {
    private final Map<String, Object> attributes;
    private final Mutator mutator;

    public CoarseSessionAttributes(Map<String, Object> attributes, Mutator mutator) {
        super(attributes);
        this.attributes = attributes;
        this.mutator = mutator;
    }

    public Object removeAttribute(String name) {
        Object value = this.attributes.remove(name);
        this.mutator.mutate();
        return value;
    }

    public Object setAttribute(String name, Object value) {
        Object old = value != null ? this.attributes.put(name, value) : this.attributes.remove(name);
        this.mutator.mutate();
        return old;
    }

    @Override
    public Object getAttribute(String name) {
        Object value = super.getAttribute(name);
        if (CacheMutator.isMutable(value)) {
            this.mutator.mutate();
        }
        return value;
    }
}

