/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactoryService;
import org.jboss.as.clustering.infinispan.subsystem.AbstractCacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.as.clustering.registry.RegistryService;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactory;
import org.wildfly.clustering.web.infinispan.session.SessionCacheConfigurationService;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryBuilder;

public class InfinispanSessionManagerFactoryBuilder
implements SessionManagerFactoryBuilder {
    public static final ServiceName ROUTING_REGISTRY_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"web", "routing", "registry"});
    public static final String DEFAULT_CACHE_CONTAINER = "web";

    public ServiceBuilder<SessionManagerFactory> build(ServiceTarget target, ServiceName name, ServiceName deploymentServiceName, Module module, JBossWebMetaData metaData) {
        ServiceName templateCacheServiceName = this.getCacheServiceName(metaData.getReplicationConfig());
        String templateCacheName = templateCacheServiceName.getSimpleName();
        ServiceName containerServiceName = templateCacheServiceName.getParent();
        String containerName = containerServiceName.getSimpleName();
        ServiceName templateCacheConfigurationServiceName = AbstractCacheConfigurationService.getServiceName((String)containerName, (String)templateCacheName);
        String host = deploymentServiceName.getParent().getSimpleName();
        String contextPath = deploymentServiceName.getSimpleName();
        StringBuilder cacheNameBuilder = new StringBuilder(host).append(contextPath);
        if (contextPath.isEmpty() || contextPath.equals("/")) {
            cacheNameBuilder.append("ROOT");
        }
        String cacheName = cacheNameBuilder.toString();
        ServiceName cacheConfigurationServiceName = AbstractCacheConfigurationService.getServiceName((String)containerName, (String)cacheName);
        ServiceName cacheServiceName = CacheService.getServiceName((String)containerName, (String)cacheName);
        InjectedValue container = new InjectedValue();
        InjectedValue config = new InjectedValue();
        target.addService(cacheConfigurationServiceName, (Service)new SessionCacheConfigurationService(cacheName, (Value<EmbeddedCacheManager>)container, (Value<Configuration>)config, metaData)).addDependency(containerServiceName, EmbeddedCacheManager.class, (Injector)container).addDependency(templateCacheConfigurationServiceName, Configuration.class, (Injector)config).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        final InjectedValue cacheContainer = new InjectedValue();
        CacheService.Dependencies dependencies = new CacheService.Dependencies(){

            public EmbeddedCacheManager getCacheContainer() {
                return (EmbeddedCacheManager)cacheContainer.getValue();
            }

            public XAResourceRecoveryRegistry getRecoveryRegistry() {
                return null;
            }
        };
        AsynchronousService.addService((ServiceTarget)target, (ServiceName)cacheServiceName, (Service)new CacheService(cacheName, dependencies)).addDependency(cacheConfigurationServiceName).addDependency(containerServiceName, EmbeddedCacheManager.class, (Injector)cacheContainer).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        InjectedValue cache = new InjectedValue();
        InjectedValue affinityFactory = new InjectedValue();
        InjectedValue routingRegistry = new InjectedValue();
        return target.addService(name, (Service)new InfinispanSessionManagerFactory(module, metaData, (Value<Cache>)cache, (Value<KeyAffinityServiceFactory>)affinityFactory, (Value<Registry>)routingRegistry)).addDependency(cacheServiceName, Cache.class, (Injector)cache).addDependency(KeyAffinityServiceFactoryService.getServiceName((String)containerName), KeyAffinityServiceFactory.class, (Injector)affinityFactory).addDependency(ROUTING_REGISTRY_SERVICE_NAME, Registry.class, (Injector)routingRegistry);
    }

    private ServiceName getCacheServiceName(ReplicationConfig config) {
        String cacheName;
        ServiceName serviceName;
        ServiceName baseServiceName = EmbeddedCacheManagerService.getServiceName(null);
        if (!baseServiceName.isParentOf(serviceName = ServiceName.parse((String)((cacheName = config != null ? config.getCacheName() : null) != null ? cacheName : DEFAULT_CACHE_CONTAINER)))) {
            serviceName = baseServiceName.append(serviceName);
        }
        return serviceName.length() < 4 ? serviceName.append(new String[]{"___defaultcache"}) : serviceName;
    }

    public ServiceBuilder<?> buildServerDependency(ServiceTarget target, final Value<String> instanceId) {
        Registry.RegistryEntryProvider<String, Void> provider = new Registry.RegistryEntryProvider<String, Void>(){

            public String getKey() {
                return (String)instanceId.getValue();
            }

            public Void getValue() {
                return null;
            }
        };
        InjectedValue cache = new InjectedValue();
        return AsynchronousService.addService((ServiceTarget)target, (ServiceName)ROUTING_REGISTRY_SERVICE_NAME, (Service)new RegistryService((Value)cache, (Value)new ImmediateValue((Object)provider))).addDependency(CacheService.getServiceName((String)DEFAULT_CACHE_CONTAINER, null), Cache.class, (Injector)cache).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

