/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.time.Duration;
import java.util.function.Predicate;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.ee.cache.scheduler.LocalScheduler;
import org.wildfly.clustering.ee.cache.scheduler.ScheduledEntries;
import org.wildfly.clustering.ee.cache.scheduler.SortedScheduledEntries;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.GroupedKey;
import org.wildfly.clustering.ee.infinispan.scheduler.Scheduler;
import org.wildfly.clustering.infinispan.distribution.Locality;
import org.wildfly.clustering.web.cache.session.ImmutableSessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.SessionExpirationMetaData;

public class SessionExpirationScheduler<MV>
implements Scheduler<String, SessionExpirationMetaData>,
Predicate<String> {
    private final LocalScheduler<String> scheduler;
    private final Batcher<TransactionBatch> batcher;
    private final Remover<String> remover;
    private final ImmutableSessionMetaDataFactory<MV> metaDataFactory;

    public SessionExpirationScheduler(Batcher<TransactionBatch> batcher, ImmutableSessionMetaDataFactory<MV> metaDataFactory, Remover<String> remover, Duration closeTimeout) {
        this.scheduler = new LocalScheduler((ScheduledEntries)new SortedScheduledEntries(), (Predicate)this, closeTimeout);
        this.batcher = batcher;
        this.metaDataFactory = metaDataFactory;
        this.remover = remover;
    }

    public void schedule(String sessionId) {
        Object value = this.metaDataFactory.findValue((Object)sessionId);
        if (value != null) {
            ImmutableSessionMetaData metaData = this.metaDataFactory.createImmutableSessionMetaData(sessionId, value);
            this.schedule(sessionId, (SessionExpirationMetaData)metaData);
        }
    }

    public void schedule(String sessionId, SessionExpirationMetaData metaData) {
        Duration maxInactiveInterval = metaData.getMaxInactiveInterval();
        if (!maxInactiveInterval.isZero()) {
            this.scheduler.schedule((Object)sessionId, metaData.getLastAccessEndTime().plus(maxInactiveInterval));
        }
    }

    public void cancel(String sessionId) {
        this.scheduler.cancel((Object)sessionId);
    }

    public void cancel(Locality locality) {
        for (String sessionId : this.scheduler) {
            if (Thread.currentThread().isInterrupted()) break;
            if (locality.isLocal((Object)new GroupedKey((Object)sessionId))) continue;
            this.cancel(sessionId);
        }
    }

    public void close() {
        this.scheduler.close();
    }

    @Override
    public boolean test(String sessionId) {
        boolean bl;
        block10: {
            InfinispanWebLogger.ROOT_LOGGER.debugf("Expiring web session %s", sessionId);
            Batch batch = this.batcher.createBatch();
            try {
                this.remover.remove((Object)sessionId);
                bl = true;
                if (batch == null) break block10;
            }
            catch (RuntimeException e) {
                try {
                    try {
                        batch.discard();
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (batch != null) {
                            try {
                                batch.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (RuntimeException e2) {
                    InfinispanWebLogger.ROOT_LOGGER.failedToExpireSession(e2, sessionId);
                    return false;
                }
            }
            batch.close();
        }
        return bl;
    }
}

