/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.routing;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.ee.CompositeIterable;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceConfigurator;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameRegistry;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.spi.CacheServiceConfiguratorProvider;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.DistributedCacheServiceConfiguratorProvider;
import org.wildfly.clustering.web.cache.routing.LocalRouteServiceConfigurator;
import org.wildfly.clustering.web.infinispan.routing.InfinispanRoutingConfiguration;
import org.wildfly.clustering.web.infinispan.routing.RouteRegistryEntryProviderServiceConfigurator;
import org.wildfly.clustering.web.routing.RoutingProvider;

public class InfinispanRoutingProvider
implements RoutingProvider {
    static final Set<ClusteringCacheRequirement> REGISTRY_REQUIREMENTS = EnumSet.of(ClusteringCacheRequirement.REGISTRY, ClusteringCacheRequirement.REGISTRY_FACTORY, ClusteringCacheRequirement.GROUP);
    private final InfinispanRoutingConfiguration config;

    public InfinispanRoutingProvider(InfinispanRoutingConfiguration config) {
        this.config = config;
    }

    public Iterable<CapabilityServiceConfigurator> getServiceConfigurators(final String serverName, SupplierDependency<String> route) {
        final String containerName = this.config.getContainerName();
        String cacheName = this.config.getCacheName();
        LocalRouteServiceConfigurator localRouteConfigurator = new LocalRouteServiceConfigurator(serverName, route);
        RouteRegistryEntryProviderServiceConfigurator registryEntryConfigurator = new RouteRegistryEntryProviderServiceConfigurator(containerName, serverName);
        TemplateConfigurationServiceConfigurator configurationConfigurator = new TemplateConfigurationServiceConfigurator(ServiceNameFactory.parseServiceName((String)InfinispanCacheRequirement.CONFIGURATION.getName()).append(new String[]{containerName, serverName}), containerName, serverName, cacheName, (Consumer)this.config);
        CacheServiceConfigurator cacheConfigurator = new CacheServiceConfigurator(ServiceNameFactory.parseServiceName((String)InfinispanCacheRequirement.CACHE.getName()).append(new String[]{containerName, serverName}), containerName, serverName);
        LinkedList<Iterable> configurators = new LinkedList<Iterable>();
        configurators.add(Arrays.asList(localRouteConfigurator, registryEntryConfigurator, configurationConfigurator, cacheConfigurator));
        ServiceNameRegistry<ClusteringCacheRequirement> registry = new ServiceNameRegistry<ClusteringCacheRequirement>(){

            public ServiceName getServiceName(ClusteringCacheRequirement requirement) {
                return REGISTRY_REQUIREMENTS.contains(requirement) ? ServiceNameFactory.parseServiceName((String)requirement.getName()).append(new String[]{containerName, serverName}) : null;
            }
        };
        for (CacheServiceConfiguratorProvider cacheServiceConfiguratorProvider : ServiceLoader.load(DistributedCacheServiceConfiguratorProvider.class, DistributedCacheServiceConfiguratorProvider.class.getClassLoader())) {
            configurators.add(cacheServiceConfiguratorProvider.getServiceConfigurators((ServiceNameRegistry)registry, containerName, serverName));
        }
        return new CompositeIterable(configurators);
    }
}

