/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.coarse;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.marshall.NotSerializableException;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.infinispan.CacheProperties;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.web.infinispan.session.SessionAttributes;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseImmutableSessionAttributes;

public class CoarseSessionAttributes
extends CoarseImmutableSessionAttributes
implements SessionAttributes {
    private final Map<String, Object> attributes;
    private final Set<String> mutations;
    private final Mutator mutator;
    private final Marshallability marshallability;
    private final Immutability immutability;
    private final CacheProperties properties;

    public CoarseSessionAttributes(Map<String, Object> attributes, Mutator mutator, Marshallability marshallability, Immutability immutability, CacheProperties properties) {
        super(attributes);
        this.attributes = attributes;
        this.mutations = !properties.isTransactional() ? ConcurrentHashMap.newKeySet() : null;
        this.mutator = mutator;
        this.marshallability = marshallability;
        this.immutability = immutability;
        this.properties = properties;
    }

    public Object removeAttribute(String name) {
        Object value = this.attributes.remove(name);
        this.mutator.mutate();
        if (this.mutations != null) {
            this.mutations.remove(name);
        }
        return value;
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.removeAttribute(name);
        }
        if (this.properties.isMarshalling() && !this.marshallability.isMarshallable(value)) {
            throw new IllegalArgumentException((Throwable)new NotSerializableException(value.getClass().getName()));
        }
        Object old = this.attributes.put(name, value);
        this.mutator.mutate();
        if (this.mutations != null) {
            this.mutations.remove(name);
        }
        return old;
    }

    @Override
    public Object getAttribute(String name) {
        Object value = this.attributes.get(name);
        if (!this.immutability.test(value)) {
            if (this.mutations != null) {
                this.mutations.add(name);
            } else {
                this.mutator.mutate();
            }
        }
        return value;
    }

    @Override
    public void close() {
        if (this.mutations != null && !this.mutations.isEmpty()) {
            this.mutator.mutate();
        }
    }
}

