/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceConfigurator;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationServiceConfigurator;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManagerFactory;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManagerFactoryConfiguration;

public class InfinispanSSOManagerFactoryServiceConfigurator<A, D, S>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
InfinispanSSOManagerFactoryConfiguration {
    public static final String DEFAULT_CACHE_CONTAINER = "web";
    private final CapabilityServiceConfigurator configurationConfigurator;
    private final CapabilityServiceConfigurator cacheConfigurator;
    private volatile SupplierDependency<KeyAffinityServiceFactory> affinityFactory;
    private volatile Supplier<Cache> cache;

    public InfinispanSSOManagerFactoryServiceConfigurator(String name) {
        super(ServiceName.JBOSS.append(new String[]{"clustering", "sso", name}));
        this.configurationConfigurator = new TemplateConfigurationServiceConfigurator(ServiceName.parse((String)InfinispanCacheRequirement.CONFIGURATION.resolve(DEFAULT_CACHE_CONTAINER, name)), DEFAULT_CACHE_CONTAINER, name, null);
        this.cacheConfigurator = new CacheServiceConfigurator(ServiceName.parse((String)InfinispanCacheRequirement.CACHE.resolve(DEFAULT_CACHE_CONTAINER, name)), DEFAULT_CACHE_CONTAINER, name);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.configurationConfigurator.configure(support);
        this.cacheConfigurator.configure(support);
        this.affinityFactory = new ServiceSupplierDependency(InfinispanRequirement.KEY_AFFINITY_FACTORY.getServiceName(support, DEFAULT_CACHE_CONTAINER));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        this.configurationConfigurator.build(target).install();
        this.cacheConfigurator.build(target).install();
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer factory = this.affinityFactory.register(builder).provides(new ServiceName[]{this.getServiceName()});
        this.cache = builder.requires(this.cacheConfigurator.getServiceName());
        Service service = Service.newInstance((Consumer)factory, new InfinispanSSOManagerFactory(this));
        return builder.setInstance(service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return this.cache.get();
    }

    @Override
    public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
        return (KeyAffinityServiceFactory)this.affinityFactory.get();
    }
}

