/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.Serializer;
import org.wildfly.clustering.web.IdentifierSerializerProvider;

public class SessionKeyExternalizer<K extends Key<String>>
implements Externalizer<K> {
    static final Serializer<String> SESSION_ID_SERIALIZER = SessionKeyExternalizer.loadIdentifierSerializer(IdentifierSerializerProvider.class.getClassLoader());
    private final Class<K> targetClass;
    private final Function<String, K> resolver;

    private static Serializer<String> loadIdentifierSerializer(ClassLoader loader) {
        Iterator<IdentifierSerializerProvider> iterator = ServiceLoader.load(IdentifierSerializerProvider.class, loader).iterator();
        if (iterator.hasNext()) {
            IdentifierSerializerProvider provider = iterator.next();
            return provider.getSerializer();
        }
        throw new IllegalStateException();
    }

    protected SessionKeyExternalizer(Class<K> targetClass, Function<String, K> resolver) {
        this.targetClass = targetClass;
        this.resolver = resolver;
    }

    public void writeObject(ObjectOutput output, K key) throws IOException {
        SESSION_ID_SERIALIZER.write((DataOutput)output, key.getValue());
    }

    public K readObject(ObjectInput input) throws IOException {
        return (K)((Key)this.resolver.apply((String)SESSION_ID_SERIALIZER.read((DataInput)input)));
    }

    public Class<K> getTargetClass() {
        return this.targetClass;
    }
}

