/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.MappedValueService;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;

public class RouteRegistryEntryProviderBuilder
implements CapabilityServiceBuilder<Map.Entry<String, Void>> {
    private final String serverName;
    private final ValueDependency<String> route;

    public RouteRegistryEntryProviderBuilder(String serverName, ValueDependency<String> route) {
        this.serverName = serverName;
        this.route = route;
    }

    public ServiceName getServiceName() {
        return ServiceName.parse((String)ClusteringCacheRequirement.REGISTRY_ENTRY.resolve("web", this.serverName));
    }

    public ServiceBuilder<Map.Entry<String, Void>> build(ServiceTarget target) {
        Function<String, Map.Entry> mapper = route -> new AbstractMap.SimpleImmutableEntry<String, Object>((String)route, null);
        return this.route.register(target.addService(this.getServiceName(), (Service)new MappedValueService(mapper, this.route))).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

