/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import java.util.Map;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.infinispan.sso.SSOFactory;
import org.wildfly.clustering.web.infinispan.sso.SessionsFactory;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.Sessions;

public class InfinispanSSOManager<AV, SV, A, D, S, L>
implements SSOManager<A, D, S, L, TransactionBatch> {
    private final SSOFactory<AV, SV, A, D, S, L> factory;
    private final Batcher<TransactionBatch> batcher;
    private final IdentifierFactory<String> identifierFactory;

    public InfinispanSSOManager(SSOFactory<AV, SV, A, D, S, L> factory, IdentifierFactory<String> identifierFactory, Batcher<TransactionBatch> batcher) {
        this.factory = factory;
        this.batcher = batcher;
        this.identifierFactory = identifierFactory;
    }

    public SSO<A, D, S, L> createSSO(String ssoId, A authentication) {
        Map.Entry value = (Map.Entry)this.factory.createValue(ssoId, authentication);
        return this.factory.createSSO(ssoId, value);
    }

    public SSO<A, D, S, L> findSSO(String ssoId) {
        Map.Entry value = (Map.Entry)this.factory.findValue(ssoId);
        return value != null ? this.factory.createSSO(ssoId, value) : null;
    }

    public Sessions<D, S> findSessionsContaining(S session) {
        SessionsFactory<SV, D, S> factory = this.factory.getSessionsFactory();
        Map.Entry<String, SV> entry = factory.findEntryContaining(session);
        return entry != null ? factory.createSessions(entry.getKey(), entry.getValue()) : null;
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public String createIdentifier() {
        return (String)this.identifierFactory.createIdentifier();
    }

    public void start() {
        this.identifierFactory.start();
    }

    public void stop() {
        this.identifierFactory.stop();
    }
}

