/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.web.infinispan.session.MockImmutableSession;
import org.wildfly.clustering.web.infinispan.session.Scheduler;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionAccessMetaData;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class ScheduleSchedulerCommand
implements Command<Void, Scheduler> {
    private static final long serialVersionUID = -2606847692331278614L;
    private final transient ImmutableSession session;
    private final String id;
    private final Instant creationTime;
    private final Duration maxInactiveInterval;
    private final Duration lastAccessedDuration;

    public ScheduleSchedulerCommand(ImmutableSession session) {
        this.session = session;
        this.id = session.getId();
        ImmutableSessionMetaData metaData = session.getMetaData();
        this.creationTime = metaData.getCreationTime();
        this.maxInactiveInterval = metaData.getMaxInactiveInterval();
        this.lastAccessedDuration = Duration.between(this.creationTime, metaData.getLastAccessedTime());
    }

    public Void execute(Scheduler scheduler) {
        ImmutableSession session = this.session;
        if (session == null) {
            SimpleSessionCreationMetaData creationMetaData = new SimpleSessionCreationMetaData(this.creationTime);
            creationMetaData.setMaxInactiveInterval(this.maxInactiveInterval);
            SimpleSessionAccessMetaData accessMetaData = new SimpleSessionAccessMetaData();
            accessMetaData.setLastAccessedDuration(this.lastAccessedDuration);
            SimpleSessionMetaData metaData = new SimpleSessionMetaData(creationMetaData, accessMetaData);
            session = new MockImmutableSession(this.id, metaData);
        }
        scheduler.schedule(session);
        return null;
    }
}

