/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.IndexExternalizer;
import org.wildfly.clustering.marshalling.jboss.MarshalledValue;
import org.wildfly.clustering.marshalling.jboss.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.MarshalledValueMarshaller;
import org.wildfly.clustering.marshalling.jboss.Marshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleClassTable;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContextFactory;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.AffinityIdentifierFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManager;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionFactory;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;

public class InfinispanSessionManagerFactory
implements SessionManagerFactory<TransactionBatch> {
    private final InfinispanSessionManagerFactoryConfiguration config;

    public InfinispanSessionManagerFactory(InfinispanSessionManagerFactoryConfiguration config) {
        this.config = config;
    }

    public <L> SessionManager<L, TransactionBatch> createSessionManager(final SessionContext context, IdentifierFactory<String> identifierFactory, LocalContextFactory<L> localContextFactory, Recordable<ImmutableSession> inactiveSessionRecorder) {
        InfinispanBatcher batcher = new InfinispanBatcher(this.config.getCache());
        final Cache cache = this.config.getCache();
        final AffinityIdentifierFactory<String> factory = new AffinityIdentifierFactory<String>(identifierFactory, cache, this.config.getKeyAffinityServiceFactory());
        CommandDispatcherFactory dispatcherFactory = this.config.getCommandDispatcherFactory();
        NodeFactory<Address> nodeFactory = this.config.getNodeFactory();
        int maxActiveSessions = this.config.getSessionManagerConfiguration().getMaxActiveSessions();
        InfinispanSessionManagerConfiguration config = new InfinispanSessionManagerConfiguration((Batcher)batcher, dispatcherFactory, nodeFactory, maxActiveSessions, inactiveSessionRecorder){
            final /* synthetic */ Batcher val$batcher;
            final /* synthetic */ CommandDispatcherFactory val$dispatcherFactory;
            final /* synthetic */ NodeFactory val$nodeFactory;
            final /* synthetic */ int val$maxActiveSessions;
            final /* synthetic */ Recordable val$inactiveSessionRecorder;
            {
                this.val$batcher = batcher;
                this.val$dispatcherFactory = commandDispatcherFactory;
                this.val$nodeFactory = nodeFactory;
                this.val$maxActiveSessions = n;
                this.val$inactiveSessionRecorder = recordable;
            }

            @Override
            public SessionContext getSessionContext() {
                return context;
            }

            @Override
            public Cache<Key<String>, ?> getCache() {
                return cache;
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return factory;
            }

            @Override
            public Batcher<TransactionBatch> getBatcher() {
                return this.val$batcher;
            }

            @Override
            public CommandDispatcherFactory getCommandDispatcherFactory() {
                return this.val$dispatcherFactory;
            }

            @Override
            public NodeFactory<Address> getNodeFactory() {
                return this.val$nodeFactory;
            }

            @Override
            public int getMaxActiveSessions() {
                return this.val$maxActiveSessions;
            }

            @Override
            public Recordable<ImmutableSession> getInactiveSessionRecorder() {
                return this.val$inactiveSessionRecorder;
            }
        };
        return new InfinispanSessionManager(this.getSessionFactory(context, localContextFactory), config);
    }

    private <L> SessionFactory<?, L> getSessionFactory(SessionContext context, LocalContextFactory<L> localContextFactory) {
        SessionManagerConfiguration config = this.config.getSessionManagerConfiguration();
        Module module = config.getModule();
        SimpleMarshallingContext marshallingContext = new SimpleMarshallingContextFactory().createMarshallingContext((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, (Object)module), (ClassLoader)module.getClassLoader());
        SimpleMarshalledValueFactory factory = new SimpleMarshalledValueFactory((MarshallingContext)marshallingContext);
        Cache cache = this.config.getCache();
        Configuration cacheConfig = cache.getCacheConfiguration();
        boolean lockOnRead = cacheConfig.transaction().transactionMode().isTransactional() && cacheConfig.transaction().lockingMode() == LockingMode.PESSIMISTIC && cacheConfig.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ;
        switch (config.getAttributePersistenceStrategy()) {
            case FINE: {
                MarshalledValueMarshaller marshaller = new MarshalledValueMarshaller((MarshalledValueFactory)factory, (Object)marshallingContext);
                return new FineSessionFactory<L>(cache, context, (Marshaller<Object, MarshalledValue<Object, MarshallingContext>, MarshallingContext>)marshaller, localContextFactory, lockOnRead);
            }
            case COARSE: {
                MarshalledValueMarshaller marshaller = new MarshalledValueMarshaller((MarshalledValueFactory)factory, (Object)marshallingContext);
                return new CoarseSessionFactory<L>(cache, context, (Marshaller<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>, MarshallingContext>)marshaller, localContextFactory, lockOnRead);
            }
        }
        throw new IllegalStateException();
    }

    static enum MarshallingVersion implements Function<Module, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(Module module) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
                config.setClassTable((ClassTable)new SimpleClassTable((Externalizer)IndexExternalizer.UNSIGNED_BYTE, new Class[]{Serializable.class, Externalizable.class}));
                return config;
            }
        }
        ,
        VERSION_2{

            @Override
            public MarshallingConfiguration apply(Module module) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
                config.setClassTable((ClassTable)new SimpleClassTable((Externalizer)IndexExternalizer.UNSIGNED_BYTE, new Class[]{Serializable.class, Externalizable.class}));
                config.setObjectTable((ObjectTable)new ExternalizerObjectTable((ClassLoader)module.getClassLoader()));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_2;
        }
    }
}

