/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Function;
import org.wildfly.clustering.infinispan.client.Key;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.Serializer;
import org.wildfly.clustering.web.cache.SessionIdentifierSerializer;

public class SessionKeyExternalizer<K extends Key<String>>
implements Externalizer<K> {
    private static final Serializer<String> IDENTIFIER_SERIALIZER = SessionIdentifierSerializer.INSTANCE;
    private final Class<K> targetClass;
    private final Function<String, K> resolver;

    public SessionKeyExternalizer(Class<K> targetClass, Function<String, K> resolver) {
        this.targetClass = targetClass;
        this.resolver = resolver;
    }

    public void writeObject(ObjectOutput output, K key) throws IOException {
        IDENTIFIER_SERIALIZER.write((DataOutput)output, key.getId());
    }

    public K readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        String id = (String)IDENTIFIER_SERIALIZER.read((DataInput)input);
        return (K)((Key)this.resolver.apply(id));
    }

    public Class<K> getTargetClass() {
        return this.targetClass;
    }
}

