/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfiguration;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.Marshaller;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.ExecutorServiceFactory;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.ImmutableSessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.ImmutableSessionMetaDataFactory;
import org.wildfly.clustering.web.cache.session.SessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.cache.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.cache.session.SimpleSessionCreationMetaData;
import org.wildfly.clustering.web.hotrod.logging.Logger;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionMetaDataFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@ClientListener(converterFactoryName="___eager-key-value-version-converter", useRawData=true)
public class HotRodSessionFactory<C, V, L>
extends CompositeSessionFactory<C, V, L>
implements Registrar<SessionExpirationListener> {
    private final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataCache;
    private final RemoteCache<SessionAccessMetaDataKey, SessionAccessMetaData> accessMetaDataCache;
    private final ImmutableSessionMetaDataFactory<CompositeSessionMetaDataEntry<L>> metaDataFactory;
    private final ImmutableSessionAttributesFactory<V> attributesFactory;
    private final Remover<String> attributesRemover;
    private final Collection<SessionExpirationListener> listeners = new CopyOnWriteArraySet<SessionExpirationListener>();
    private final ExecutorService executor = new DefaultExecutorService(((Object)((Object)this)).getClass(), (Function)ExecutorServiceFactory.CACHED_THREAD);
    private final boolean nearCacheEnabled;

    public HotRodSessionFactory(HotRodSessionMetaDataFactoryConfiguration config, SessionMetaDataFactory<CompositeSessionMetaDataEntry<L>> metaDataFactory, SessionAttributesFactory<C, V> attributesFactory, LocalContextFactory<L> localContextFactory) {
        super(metaDataFactory, attributesFactory, localContextFactory);
        this.metaDataFactory = metaDataFactory;
        this.attributesFactory = attributesFactory;
        this.attributesRemover = attributesFactory;
        this.creationMetaDataCache = config.getCache();
        this.accessMetaDataCache = config.getCache();
        this.creationMetaDataCache.addClientListener((Object)this, null, new Object[]{Boolean.TRUE});
        this.nearCacheEnabled = ((RemoteCacheConfiguration)this.creationMetaDataCache.getRemoteCacheManager().getConfiguration().remoteCaches().get(this.creationMetaDataCache.getName())).nearCacheMode().enabled();
    }

    public void close() {
        this.creationMetaDataCache.removeClientListener((Object)this);
        WildFlySecurityManager.doUnchecked((Object)this.executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_ACTION);
        try {
            this.executor.awaitTermination(this.creationMetaDataCache.getRemoteCacheManager().getConfiguration().transaction().timeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @ClientCacheEntryExpired
    public void expired(final ClientCacheEntryCustomEvent<byte[]> event) {
        final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataCache = this.creationMetaDataCache;
        final RemoteCache<SessionAccessMetaDataKey, SessionAccessMetaData> accessMetaDataCache = this.accessMetaDataCache;
        final ImmutableSessionMetaDataFactory<CompositeSessionMetaDataEntry<L>> metaDataFactory = this.metaDataFactory;
        final ImmutableSessionAttributesFactory<V> attributesFactory = this.attributesFactory;
        final Remover<String> attributesRemover = this.attributesRemover;
        final Collection<SessionExpirationListener> listeners = this.listeners;
        final boolean nearCacheEnabled = this.nearCacheEnabled;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                byte[] value;
                ByteBuffer buffer = ByteBuffer.wrap((byte[])event.getEventData());
                byte[] key = new byte[UnsignedNumeric.readUnsignedInt((ByteBuffer)buffer)];
                buffer.get(key);
                byte[] byArray = value = buffer.remaining() > 0 ? new byte[UnsignedNumeric.readUnsignedInt((ByteBuffer)buffer)] : null;
                if (value != null) {
                    buffer.get(value);
                }
                Marshaller marshaller = creationMetaDataCache.getRemoteCacheManager().getConfiguration().marshaller();
                String id = null;
                try {
                    Object attributesValue;
                    SessionAccessMetaData accessMetaData;
                    SessionCreationMetaDataEntry creationEntry;
                    SessionCreationMetaDataKey creationKey = (SessionCreationMetaDataKey)((Object)marshaller.objectFromByteBuffer(key));
                    id = (String)creationKey.getId();
                    SessionCreationMetaDataEntry sessionCreationMetaDataEntry = creationEntry = value != null ? (SessionCreationMetaDataEntry)marshaller.objectFromByteBuffer(value) : new SessionCreationMetaDataEntry((SessionCreationMetaData)new SimpleSessionCreationMetaData(Instant.EPOCH));
                    if (nearCacheEnabled) {
                        creationMetaDataCache.remove((Object)creationKey);
                    }
                    if ((accessMetaData = (SessionAccessMetaData)accessMetaDataCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)new SessionAccessMetaDataKey(id))) != null && (attributesValue = attributesFactory.findValue((Object)id)) != null) {
                        ImmutableSessionMetaData metaData = metaDataFactory.createImmutableSessionMetaData(id, (Object)new CompositeSessionMetaDataEntry(creationEntry, accessMetaData));
                        ImmutableSessionAttributes attributes = attributesFactory.createImmutableSessionAttributes(id, attributesValue);
                        ImmutableSession session = HotRodSessionFactory.this.createImmutableSession(id, metaData, attributes);
                        Logger.ROOT_LOGGER.tracef("Session %s has expired.", id);
                        for (SessionExpirationListener listener : listeners) {
                            listener.sessionExpired(session);
                        }
                        attributesRemover.remove((Object)id);
                    }
                }
                catch (IOException | ClassNotFoundException e) {
                    Logger.ROOT_LOGGER.failedToExpireSession(e, id);
                }
            }
        };
        this.executor.submit(task);
    }

    public Registration register(SessionExpirationListener listener) {
        this.listeners.add(listener);
        return () -> this.listeners.remove(listener);
    }
}

