/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Predicate;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.scheduler.LocalScheduler;
import org.wildfly.clustering.ee.cache.scheduler.ScheduledEntries;
import org.wildfly.clustering.ee.cache.scheduler.SortedScheduledEntries;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.web.hotrod.logging.Logger;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class SessionExpirationScheduler
implements Scheduler<String, ImmutableSessionMetaData>,
Predicate<String> {
    private final Scheduler<String, Instant> scheduler;
    private final Batcher<TransactionBatch> batcher;
    private final Remover<String> remover;

    public SessionExpirationScheduler(Batcher<TransactionBatch> batcher, Remover<String> remover, Duration closeTimeout) {
        this.scheduler = new LocalScheduler((ScheduledEntries)new SortedScheduledEntries(), (Predicate)this, closeTimeout);
        this.batcher = batcher;
        this.remover = remover;
    }

    public void cancel(String sessionId) {
        this.scheduler.cancel((Object)sessionId);
    }

    public void schedule(String sessionId, ImmutableSessionMetaData metaData) {
        Duration maxInactiveInterval = metaData.getMaxInactiveInterval();
        if (!maxInactiveInterval.isZero()) {
            Logger.ROOT_LOGGER.tracef("Session %s will expire in %s", sessionId, maxInactiveInterval);
            this.scheduler.schedule((Object)sessionId, (Object)metaData.getLastAccessedTime().plus(maxInactiveInterval));
        }
    }

    public void close() {
        this.scheduler.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean test(String sessionId) {
        Logger.ROOT_LOGGER.debugf("Expiring web session %s", sessionId);
        try {
            Throwable throwable = null;
            try (Batch batch = this.batcher.createBatch();){
                this.remover.remove((Object)sessionId);
                boolean bl = true;
                return bl;
            }
            catch (RuntimeException e) {
                try {
                    batch.discard();
                    throw e;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
        catch (RuntimeException e2) {
            Logger.ROOT_LOGGER.failedToExpireSession(e2, sessionId);
            return false;
        }
    }
}

