/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.fine;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.hotrod.Logger;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class FineImmutableSessionAttributes<V>
implements ImmutableSessionAttributes {
    private final String id;
    private final Map<String, UUID> names;
    private final RemoteCache<SessionAttributeKey, V> cache;
    private final Marshaller<Object, V> marshaller;

    public FineImmutableSessionAttributes(String id, Map<String, UUID> names, RemoteCache<SessionAttributeKey, V> cache, Marshaller<Object, V> marshaller) {
        this.id = id;
        this.names = names;
        this.cache = cache;
        this.marshaller = marshaller;
    }

    public Set<String> getAttributeNames() {
        return this.names.keySet();
    }

    public Object getAttribute(String name) {
        UUID attributeId = this.names.get(name);
        return attributeId != null ? this.read(name, this.cache.get((Object)new SessionAttributeKey(this.id, attributeId))) : null;
    }

    protected Object read(String name, V value) {
        try {
            return this.marshaller.read(value);
        }
        catch (InvalidSerializedFormException e) {
            throw Logger.ROOT_LOGGER.failedToReadSessionAttribute(e, this.id.toString(), name);
        }
    }
}

