/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.hotrod.RemoteCacheManagerProperties;
import org.wildfly.clustering.ee.hotrod.tx.HotRodBatcher;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueMarshaller;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.hotrod.session.ExpiredSessionRemover;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManager;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionMetaDataFactory;
import org.wildfly.clustering.web.hotrod.session.Scheduler;
import org.wildfly.clustering.web.hotrod.session.SessionExpirationScheduler;
import org.wildfly.clustering.web.hotrod.session.coarse.CoarseSessionAttributesFactory;
import org.wildfly.clustering.web.hotrod.session.fine.FineSessionAttributesFactory;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;

public class HotRodSessionManagerFactory<L, C extends Marshallability>
implements SessionManagerFactory<L, TransactionBatch> {
    final Registrar<SessionExpirationListener> expirationRegistrar;
    final Scheduler expirationScheduler;
    final Batcher<TransactionBatch> batcher;
    final Duration transactionTimeout;
    private final SessionFactory<CompositeSessionMetaDataEntry<L>, ?, L> sessionFactory;

    public HotRodSessionManagerFactory(HotRodSessionManagerFactoryConfiguration<C, L> config) {
        RemoteCacheManagerProperties properties = new RemoteCacheManagerProperties(config.getCache().getRemoteCacheManager().getConfiguration());
        HotRodSessionMetaDataFactory metaDataFactory = new HotRodSessionMetaDataFactory(config.getCache(), (CacheProperties)properties);
        this.sessionFactory = new CompositeSessionFactory(metaDataFactory, this.createSessionAttributesFactory(config, (CacheProperties)properties), config.getLocalContextFactory());
        ExpiredSessionRemover remover = new ExpiredSessionRemover(this.sessionFactory);
        this.expirationRegistrar = remover;
        this.expirationScheduler = new SessionExpirationScheduler(remover);
        this.batcher = new HotRodBatcher(config.getCache());
        this.transactionTimeout = Duration.ofMillis(config.getCache().getRemoteCacheManager().getConfiguration().transaction().timeout());
    }

    public SessionManager<L, TransactionBatch> createSessionManager(final SessionManagerConfiguration configuration) {
        HotRodSessionManagerConfiguration config = new HotRodSessionManagerConfiguration(){

            @Override
            public SessionExpirationListener getExpirationListener() {
                return configuration.getExpirationListener();
            }

            @Override
            public Registrar<SessionExpirationListener> getExpirationRegistrar() {
                return HotRodSessionManagerFactory.this.expirationRegistrar;
            }

            @Override
            public Scheduler getExpirationScheduler() {
                return HotRodSessionManagerFactory.this.expirationScheduler;
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return configuration.getIdentifierFactory();
            }

            @Override
            public ServletContext getServletContext() {
                return configuration.getServletContext();
            }

            @Override
            public Batcher<TransactionBatch> getBatcher() {
                return HotRodSessionManagerFactory.this.batcher;
            }

            @Override
            public Duration getStopTimeout() {
                return HotRodSessionManagerFactory.this.transactionTimeout;
            }
        };
        return new HotRodSessionManager(this.sessionFactory, config);
    }

    public void close() {
        this.expirationScheduler.close();
    }

    private SessionAttributesFactory<?> createSessionAttributesFactory(HotRodSessionManagerFactoryConfiguration<C, L> configuration, CacheProperties properties) {
        MarshalledValueFactory factory = configuration.getMarshalledValueFactory();
        Marshallability context = configuration.getMarshallingContext();
        switch (configuration.getAttributePersistenceStrategy()) {
            case FINE: {
                return new FineSessionAttributesFactory((RemoteCache<SessionAttributeNamesKey, Map<String, UUID>>)configuration.getCache(), configuration.getCache(), new MarshalledValueMarshaller(factory, context), properties);
            }
            case COARSE: {
                return new CoarseSessionAttributesFactory(configuration.getCache(), new MarshalledValueMarshaller(factory, context), properties);
            }
        }
        throw new IllegalStateException();
    }
}

