/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.cache.session.SimpleImmutableSession;
import org.wildfly.clustering.web.hotrod.Logger;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerConfiguration;
import org.wildfly.clustering.web.hotrod.session.Scheduler;
import org.wildfly.clustering.web.session.ImmutableHttpSessionAdapter;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionMetaData;

public class HotRodSessionManager<MV, AV, L>
implements SessionManager<L, TransactionBatch> {
    private final Registrar<SessionExpirationListener> expirationRegistrar;
    private final SessionExpirationListener expirationListener;
    private final Scheduler expirationScheduler;
    private final SessionFactory<MV, AV, L> factory;
    private final IdentifierFactory<String> identifierFactory;
    private final ServletContext context;
    private final Batcher<TransactionBatch> batcher;
    private volatile Duration defaultMaxInactiveInterval = Duration.ofMinutes(30L);
    private volatile Registration expirationRegistration;

    public HotRodSessionManager(SessionFactory<MV, AV, L> factory, HotRodSessionManagerConfiguration configuration) {
        this.factory = factory;
        this.expirationRegistrar = configuration.getExpirationRegistrar();
        this.expirationListener = configuration.getExpirationListener();
        this.expirationScheduler = configuration.getExpirationScheduler();
        this.context = configuration.getServletContext();
        this.identifierFactory = configuration.getIdentifierFactory();
        this.batcher = configuration.getBatcher();
    }

    public void start() {
        this.expirationRegistration = this.expirationRegistrar.register((Object)this.expirationListener);
    }

    public void stop() {
        this.expirationRegistration.close();
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public Duration getDefaultMaxInactiveInterval() {
        return this.defaultMaxInactiveInterval;
    }

    public void setDefaultMaxInactiveInterval(Duration duration) {
        this.defaultMaxInactiveInterval = duration;
    }

    public String createIdentifier() {
        return (String)this.identifierFactory.createIdentifier();
    }

    public Session<L> findSession(String id) {
        Map.Entry entry = (Map.Entry)this.factory.findValue(id);
        if (entry == null) {
            Logger.ROOT_LOGGER.tracef("Session %s not found", id);
            return null;
        }
        ImmutableSession session = this.factory.createImmutableSession(id, entry);
        if (session.getMetaData().isExpired()) {
            Logger.ROOT_LOGGER.tracef("Session %s was found, but has expired", id);
            this.expirationListener.sessionExpired(session);
            this.factory.remove(id);
            return null;
        }
        this.expirationScheduler.cancel(id);
        this.triggerPostActivationEvents(session);
        return new SchedulableSession(this.factory.createSession(id, entry), session);
    }

    public Session<L> createSession(String id) {
        Map.Entry entry = (Map.Entry)this.factory.createValue(id, null);
        if (entry == null) {
            return null;
        }
        Session<L> session = this.factory.createSession(id, entry);
        session.getMetaData().setMaxInactiveInterval(this.defaultMaxInactiveInterval);
        return new SchedulableSession(session, (ImmutableSession)session);
    }

    public ImmutableSession viewSession(String id) {
        Map.Entry entry = (Map.Entry)this.factory.findValue(id);
        return entry != null ? new SimpleImmutableSession(this.factory.createImmutableSession(id, entry)) : null;
    }

    public Set<String> getActiveSessions() {
        return Collections.emptySet();
    }

    public Set<String> getLocalSessions() {
        return Collections.emptySet();
    }

    public long getActiveSessionCount() {
        return this.getActiveSessions().size();
    }

    void triggerPrePassivationEvents(ImmutableSession session) {
        List<HttpSessionActivationListener> listeners = HotRodSessionManager.findListeners(session);
        if (!listeners.isEmpty()) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)new ImmutableHttpSessionAdapter(session, this.context));
            listeners.forEach(listener -> listener.sessionWillPassivate(event));
        }
    }

    void triggerPostActivationEvents(ImmutableSession session) {
        List<HttpSessionActivationListener> listeners = HotRodSessionManager.findListeners(session);
        if (!listeners.isEmpty()) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)new ImmutableHttpSessionAdapter(session, this.context));
            listeners.forEach(listener -> listener.sessionDidActivate(event));
        }
    }

    void schedule(ImmutableSession session) {
        this.expirationScheduler.schedule(session.getId(), session.getMetaData());
    }

    private static List<HttpSessionActivationListener> findListeners(ImmutableSession session) {
        ImmutableSessionAttributes attributes = session.getAttributes();
        return attributes.getAttributeNames().stream().map(name -> attributes.getAttribute(name)).filter(attribute -> attribute instanceof HttpSessionActivationListener).map(attribute -> (HttpSessionActivationListener)attribute).collect(Collectors.toList());
    }

    private class SchedulableSession
    implements Session<L> {
        private final Session<L> session;
        private final ImmutableSession immutableSession;

        SchedulableSession(Session<L> session, ImmutableSession immutableSession) {
            this.session = session;
            this.immutableSession = immutableSession;
        }

        public String getId() {
            return this.session.getId();
        }

        public SessionMetaData getMetaData() {
            if (!this.session.isValid()) {
                throw Logger.ROOT_LOGGER.invalidSession(this.getId());
            }
            return this.session.getMetaData();
        }

        public boolean isValid() {
            return this.session.isValid();
        }

        public void invalidate() {
            if (!this.session.isValid()) {
                throw Logger.ROOT_LOGGER.invalidSession(this.getId());
            }
            this.session.invalidate();
        }

        public SessionAttributes getAttributes() {
            if (!this.session.isValid()) {
                throw Logger.ROOT_LOGGER.invalidSession(this.getId());
            }
            return this.session.getAttributes();
        }

        public void close() {
            boolean valid = this.session.isValid();
            if (valid) {
                HotRodSessionManager.this.triggerPrePassivationEvents(this.immutableSession);
            }
            this.session.close();
            if (valid) {
                HotRodSessionManager.this.schedule(this.immutableSession);
            }
        }

        public L getLocalContext() {
            return this.session.getLocalContext();
        }
    }
}

