/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.util.UUID;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.hotrod.RemoteCacheEntryMutator;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionMetaData;
import org.wildfly.clustering.web.hotrod.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.hotrod.session.MutableSessionAccessMetaData;
import org.wildfly.clustering.web.hotrod.session.MutableSessionCreationMetaData;
import org.wildfly.clustering.web.hotrod.session.SessionAccessMetaData;
import org.wildfly.clustering.web.hotrod.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.hotrod.session.SimpleSessionAccessMetaData;
import org.wildfly.clustering.web.hotrod.session.SimpleSessionCreationMetaData;
import org.wildfly.clustering.web.hotrod.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class HotRodSessionMetaDataFactory<L>
implements SessionMetaDataFactory<UUID, HotRodSessionMetaData<L>, L> {
    private final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataCache;
    private final RemoteCache<SessionAccessMetaDataKey, SessionAccessMetaData> accessMetaDataCache;
    private final String deployment;

    public HotRodSessionMetaDataFactory(String deployment, RemoteCache<?, ?> cache) {
        this.creationMetaDataCache = cache;
        this.accessMetaDataCache = cache;
        this.deployment = deployment;
    }

    public HotRodSessionMetaData<L> createValue(String id, Void context) {
        SessionCreationMetaDataEntry creationMetaDataEntry = new SessionCreationMetaDataEntry(UUID.randomUUID(), new SimpleSessionCreationMetaData());
        if (this.creationMetaDataCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsent((Object)new SessionCreationMetaDataKey(this.deployment, id), creationMetaDataEntry) != null) {
            return null;
        }
        SimpleSessionAccessMetaData accessMetaData = new SimpleSessionAccessMetaData();
        this.accessMetaDataCache.put((Object)new SessionAccessMetaDataKey(creationMetaDataEntry.getId()), (Object)accessMetaData);
        return new HotRodSessionMetaData(creationMetaDataEntry, accessMetaData);
    }

    public HotRodSessionMetaData<L> findValue(String id) {
        SessionCreationMetaDataKey key = new SessionCreationMetaDataKey(this.deployment, id);
        MetadataValue value = this.creationMetaDataCache.getWithMetadata((Object)key);
        SessionCreationMetaDataEntry creationMetaDataEntry = (SessionCreationMetaDataEntry)this.creationMetaDataCache.get((Object)key);
        if (creationMetaDataEntry != null) {
            SessionAccessMetaData accessMetaData = (SessionAccessMetaData)this.accessMetaDataCache.get((Object)new SessionAccessMetaDataKey(creationMetaDataEntry.getId()));
            if (accessMetaData != null) {
                return new HotRodSessionMetaData(creationMetaDataEntry, accessMetaData);
            }
            this.creationMetaDataCache.removeWithVersion((Object)key, value.getVersion());
        }
        return null;
    }

    @Override
    public InvalidatableSessionMetaData createSessionMetaData(String id, HotRodSessionMetaData<L> entry) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(this.deployment, id);
        RemoteCacheEntryMutator creationMutator = new RemoteCacheEntryMutator(this.creationMetaDataCache, (Object)creationMetaDataKey, new SessionCreationMetaDataEntry<L>(entry));
        MutableSessionCreationMetaData creationMetaData = new MutableSessionCreationMetaData(entry.getCreationMetaData(), (Mutator)creationMutator);
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(entry.getId());
        RemoteCacheEntryMutator accessMutator = new RemoteCacheEntryMutator(this.accessMetaDataCache, (Object)accessMetaDataKey, (Object)entry.getAccessMetaData());
        MutableSessionAccessMetaData accessMetaData = new MutableSessionAccessMetaData(entry.getAccessMetaData(), (Mutator)accessMutator);
        return new SimpleSessionMetaData(creationMetaData, accessMetaData);
    }

    @Override
    public ImmutableSessionMetaData createImmutableSessionMetaData(String id, HotRodSessionMetaData<L> entry) {
        return new SimpleSessionMetaData(entry.getCreationMetaData(), entry.getAccessMetaData());
    }

    @Override
    public UUID remove(String id) {
        SessionCreationMetaDataKey key = new SessionCreationMetaDataKey(this.deployment, id);
        SessionCreationMetaDataEntry creationMetaData = (SessionCreationMetaDataEntry)this.creationMetaDataCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)key);
        if (creationMetaData == null) {
            return null;
        }
        UUID uuid = creationMetaData.getId();
        this.accessMetaDataCache.remove((Object)new SessionAccessMetaDataKey(uuid));
        return uuid;
    }
}

