/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.fine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.marshall.NotSerializableException;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.hotrod.RemoteCacheEntryMutator;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.hotrod.session.SessionAttributes;
import org.wildfly.clustering.web.hotrod.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.session.SessionAttributeImmutability;

public class FineSessionAttributes<K, V>
extends FineImmutableSessionAttributes<K, V>
implements SessionAttributes {
    private final AtomicInteger sequence;
    private final ConcurrentMap<String, Integer> names;
    private final Mutator namesMutator;
    private final RemoteCache<SessionAttributeKey<K>, V> cache;
    private final Function<Integer, SessionAttributeKey<K>> keyFactory;
    private final Map<String, Mutator> mutations = new ConcurrentHashMap<String, Mutator>();
    private final Marshaller<Object, V> marshaller;

    public FineSessionAttributes(K key, AtomicInteger sequence, ConcurrentMap<String, Integer> names, Mutator namesMutator, RemoteCache<SessionAttributeKey<K>, V> cache, Function<Integer, SessionAttributeKey<K>> keyFactory, Marshaller<Object, V> marshaller) {
        super(key, names, cache, keyFactory, marshaller);
        this.sequence = sequence;
        this.names = names;
        this.namesMutator = namesMutator;
        this.cache = cache;
        this.keyFactory = keyFactory;
        this.marshaller = marshaller;
    }

    public Object removeAttribute(String name) {
        Integer attributeId = (Integer)this.names.remove(name);
        if (attributeId == null) {
            return null;
        }
        this.namesMutator.mutate();
        SessionAttributeKey<K> key = this.keyFactory.apply(attributeId);
        Object result = this.read(name, this.cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove(key));
        this.mutations.remove(name);
        return result;
    }

    public Object setAttribute(String name, Object attribute) {
        if (attribute == null) {
            return this.removeAttribute(name);
        }
        if (!this.marshaller.isMarshallable(attribute)) {
            throw new IllegalArgumentException((Throwable)new NotSerializableException(attribute.getClass().getName()));
        }
        Object value = this.marshaller.write(attribute);
        int currentId = this.sequence.get();
        int attributeId = this.names.computeIfAbsent(name, key -> this.sequence.incrementAndGet());
        if (attributeId > currentId) {
            this.namesMutator.mutate();
        }
        SessionAttributeKey<K> key2 = this.keyFactory.apply(attributeId);
        Object result = this.read(name, this.cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put(key2, value));
        this.mutations.remove(name);
        return result;
    }

    @Override
    public Object getAttribute(String name) {
        Integer attributeId = (Integer)this.names.get(name);
        if (attributeId == null) {
            return null;
        }
        SessionAttributeKey<K> key = this.keyFactory.apply(attributeId);
        Object value = this.cache.get(key);
        Object attribute = this.read(name, value);
        if (attribute != null && !SessionAttributeImmutability.INSTANCE.test(attribute)) {
            this.mutations.computeIfAbsent(name, k -> new RemoteCacheEntryMutator(this.cache, (Object)key, value));
        }
        return attribute;
    }

    @Override
    public void close() {
        this.mutations.values().forEach(Mutator::mutate);
        this.mutations.clear();
    }
}

