/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod;

import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.commons.marshall.Marshaller;
import org.wildfly.clustering.web.hotrod.HotRodMarshaller;
import org.wildfly.clustering.web.hotrod.RemoteCacheManagerConfiguration;

public class RemoteCacheManagerFactory
implements Supplier<RemoteCacheManager> {
    private final RemoteCacheManagerConfiguration config;

    public RemoteCacheManagerFactory(RemoteCacheManagerConfiguration config) {
        this.config = config;
    }

    @Override
    public RemoteCacheManager get() {
        int maxActiveSessions = this.config.getMaxActiveSessions();
        Configuration configuration = new ConfigurationBuilder().withProperties(this.config.getProperties()).nearCache().mode(maxActiveSessions == 0 ? NearCacheMode.DISABLED : NearCacheMode.INVALIDATED).maxEntries(maxActiveSessions * 3).marshaller((Marshaller)new HotRodMarshaller(this.getClass().getClassLoader())).build();
        return new RemoteCacheManager(configuration, false);
    }
}

