/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.function.UnaryOperator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.infinispan.service.InfinispanCacheConfigurationAttributeGroup;
import org.wildfly.clustering.server.service.CacheConfigurationAttributeGroup;
import org.wildfly.clustering.web.service.routing.RoutingProvider;
import org.wildfly.extension.clustering.web.RoutingProviderResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.web.RoutingProviderResourceRegistration;
import org.wildfly.extension.clustering.web.routing.infinispan.InfinispanRoutingProvider;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class InfinispanRoutingProviderResourceDefinitionRegistrar
extends RoutingProviderResourceDefinitionRegistrar {
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((NullaryServiceDescriptor)RoutingProvider.INFINISPAN_SERVICE_DESCRIPTOR).build();
    static final CacheConfigurationAttributeGroup CACHE_ATTRIBUTE_GROUP = new InfinispanCacheConfigurationAttributeGroup(CAPABILITY);

    InfinispanRoutingProviderResourceDefinitionRegistrar() {
        super(RoutingProviderResourceRegistration.INFINISPAN);
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)super.apply(builder).addCapability(CAPABILITY)).addAttributes(CACHE_ATTRIBUTE_GROUP.getAttributes());
    }

    public RoutingProvider resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        return new InfinispanRoutingProvider(CACHE_ATTRIBUTE_GROUP.resolve(context, model), UnaryOperator.identity());
    }

    @Override
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(RoutingProviderResourceDefinitionRegistrar.CAPABILITY, (Object)this.resolve(context, model)).provides(CAPABILITY.getCapabilityServiceName())).build();
    }
}

