/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.util.function.Supplier;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.web.cache.Contextual;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSession;
import org.wildfly.clustering.web.cache.session.attributes.SessionAttributes;
import org.wildfly.clustering.web.cache.session.metadata.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionMetaData;

public class CompositeSession<L>
extends CompositeImmutableSession
implements Session<L> {
    private final InvalidatableSessionMetaData metaData;
    private final SessionAttributes attributes;
    private final Contextual<L> contextual;
    private final Supplier<L> contextFactory;
    private final Remover<String> remover;

    public CompositeSession(String id, InvalidatableSessionMetaData metaData, SessionAttributes attributes, Contextual<L> contextual, Supplier<L> contextFactory, Remover<String> remover) {
        super(id, (ImmutableSessionMetaData)metaData, (ImmutableSessionAttributes)attributes);
        this.metaData = metaData;
        this.attributes = attributes;
        this.contextual = contextual;
        this.contextFactory = contextFactory;
        this.remover = remover;
    }

    public SessionAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isValid() {
        return this.metaData.isValid();
    }

    public void invalidate() {
        if (this.metaData.invalidate()) {
            this.remover.remove((Object)this.getId());
        }
    }

    public SessionMetaData getMetaData() {
        return this.metaData;
    }

    public void close() {
        if (this.metaData.isValid()) {
            this.attributes.close();
            this.metaData.close();
        }
    }

    public L getLocalContext() {
        return this.contextual.getContext(this.contextFactory);
    }
}

